/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/actions/BasicAction", "actionPerformed"));
        }
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
        VirtualFile[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null) : "The action is only available when files are selected";
        assert (project != null);
        GitVcs vcs = GitVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles)) {
            return;
        }
        final String actionName = this.getActionName();
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        final VirtualFile[] affectedFiles = this.collectAffectedFiles(project, vFiles);
        boolean background = this.perform(project, vcs, exceptions, affectedFiles);
        if (!background) {
            GitVcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/BasicAction$1", "run"));
                    }
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])affectedFiles);
                    VcsFileUtil.markFilesDirty((Project)project, Arrays.asList(affectedFiles));
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationErrors(project, exceptions, actionName));
                }
            });
        }
    }

    protected abstract boolean perform(@NotNull Project var1, GitVcs var2, @NotNull List<VcsException> var3, @NotNull VirtualFile[] var4);

    @NotNull
    protected VirtualFile[] collectAffectedFiles(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/BasicAction", "collectAffectedFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/actions/BasicAction", "collectAffectedFiles"));
        }
        ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>(files.length);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            if (!file.isDirectory() && projectLevelVcsManager.getVcsFor(file) instanceof GitVcs) {
                affectedFiles.add(file);
                continue;
            }
            if (!file.isDirectory() || !this.isRecursive()) continue;
            this.addChildren(project, affectedFiles, file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(affectedFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/BasicAction", "collectAffectedFiles"));
        }
        return virtualFileArray;
    }

    private void addChildren(final @NotNull Project project, final @NotNull List<VirtualFile> files, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/BasicAction", "addChildren"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/actions/BasicAction", "addChildren"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/actions/BasicAction", "addChildren"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, this.isRecursive() ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/actions/BasicAction$2", "visitFile"));
                }
                if (!file.isDirectory() && BasicAction.this.appliesTo(project, file)) {
                    files.add(file);
                }
                return true;
            }
        });
    }

    @NotNull
    protected abstract String getActionName();

    protected boolean isRecursive() {
        return true;
    }

    protected boolean appliesTo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/BasicAction", "appliesTo"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/actions/BasicAction", "appliesTo"));
        }
        return !file.isDirectory();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/BasicAction", "update"));
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        boolean enabled = ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles) && this.isEnabled(project, vcs, vFiles);
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
    }

    protected abstract boolean isEnabled(@NotNull Project var1, @NotNull GitVcs var2, VirtualFile ... var3);

    public static void saveAll() {
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }
}

