/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMerge
extends GitMergeAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("merge.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitMerge", "getActionName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitMerge", "displayDialog"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitMerge", "displayDialog"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitMerge", "displayDialog"));
        }
        GitVcs vcs = GitVcs.getInstance(project);
        if (vcs == null) {
            return null;
        }
        GitMergeDialog dialog = new GitMergeDialog(project, gitRoots, defaultRoot);
        try {
            dialog.updateBranches();
        }
        catch (VcsException e) {
            if (vcs.getExecutableValidator().checkExecutableAndShowMessageIfNeeded(null)) {
                vcs.showErrors(Collections.singletonList(e), GitBundle.getString("merge.retrieving.branches"));
            }
            return null;
        }
        if (!dialog.showAndGet()) {
            return null;
        }
        return new GitMergeAction.DialogState(dialog.getSelectedRoot(), GitBundle.message("merging.title", dialog.getSelectedRoot().getPath()), (Computable<GitLineHandler>)((Computable)() -> dialog.handler()));
    }
}

