/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.collect.Maps;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteBranchOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteBranchOperation.class);
    static final String RESTORE = "Restore";
    static final String VIEW_COMMITS = "View Commits";
    static final String DELETE_TRACKED_BRANCH = "Delete Tracked Branch";
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final MultiMap<String, GitRepository> myTrackedBranches;
    @NotNull
    private final Map<GitRepository, UnmergedBranchInfo> myUnmergedToBranches;
    @NotNull
    private final Map<GitRepository, String> myDeletedBranchTips;

    GitDeleteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitDeleteBranchOperation", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/branch/GitDeleteBranchOperation", "<init>"));
        }
        if (uiHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiHandler", "git4idea/branch/GitDeleteBranchOperation", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitDeleteBranchOperation", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitDeleteBranchOperation", "<init>"));
        }
        super(project, git, uiHandler, repositories);
        this.myBranchName = branchName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myTrackedBranches = GitDeleteBranchOperation.groupByTrackedBranchName(branchName, repositories);
        this.myUnmergedToBranches = ContainerUtil.newHashMap();
        this.myDeletedBranchTips = ContainerUtil.map2MapNotNull(repositories, repo -> {
            GitBranchesCollection branches = repo.getBranches();
            GitLocalBranch branch = branches.findLocalBranch(this.myBranchName);
            if (branch == null) {
                LOG.error("Couldn't find branch by name " + this.myBranchName + " in " + repo);
                return null;
            }
            Hash hash = branches.getHash(branch);
            if (hash == null) {
                LOG.error("Couldn't find hash for branch " + branch + " in " + repo);
                return null;
            }
            return Pair.create((Object)repo, (Object)hash.asString());
        });
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitBranchNotMergedToUpstreamDetector notMergedToUpstreamDetector;
            GitSimpleEventDetector notFullyMergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.branchDelete(repository, this.myBranchName, false, notFullyMergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.BRANCH_NOT_FULLY_MERGED), notMergedToUpstreamDetector = new GitBranchNotMergedToUpstreamDetector());
            if (result2.success()) {
                GitDeleteBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (notFullyMergedDetector.hasHappened()) {
                String baseBranch = notMergedToUpstreamDetector.getBaseBranch();
                if (baseBranch == null) {
                    baseBranch = (String)this.myCurrentHeads.get(repository);
                }
                this.myUnmergedToBranches.put(repository, new UnmergedBranchInfo(this.myDeletedBranchTips.get(repository), GitBranchUtil.stripRefsPrefix(baseBranch)));
                GitCommandResult forceDeleteResult = this.myGit.branchDelete(repository, this.myBranchName, true, new GitLineHandlerListener[0]);
                if (forceDeleteResult.success()) {
                    GitDeleteBranchOperation.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getErrorTitle(), forceDeleteResult.getErrorOutputAsHtmlString());
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(this.getErrorTitle(), result2.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
        }
    }

    @Override
    protected void notifySuccess() {
        boolean unmergedCommits = !this.myUnmergedToBranches.isEmpty();
        String message = "<b>Deleted Branch:</b> " + this.myBranchName;
        if (unmergedCommits) {
            message = message + "<br/>Unmerged commits were discarded";
        }
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.INFORMATION, null);
        notification.addAction((AnAction)new NotificationAction(RESTORE){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/GitDeleteBranchOperation$1", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation$1", "actionPerformed"));
                }
                GitDeleteBranchOperation.this.restoreInBackground(notification);
            }
        });
        if (unmergedCommits) {
            notification.addAction((AnAction)new NotificationAction(VIEW_COMMITS){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/GitDeleteBranchOperation$2", "actionPerformed"));
                    }
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation$2", "actionPerformed"));
                    }
                    GitDeleteBranchOperation.this.viewUnmergedCommitsInBackground(notification);
                }
            });
        }
        if (!this.myTrackedBranches.isEmpty() && GitDeleteBranchOperation.hasOnlyTrackingBranch(this.myTrackedBranches, this.myBranchName)) {
            notification.addAction((AnAction)new NotificationAction(DELETE_TRACKED_BRANCH){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/GitDeleteBranchOperation$3", "actionPerformed"));
                    }
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation$3", "actionPerformed"));
                    }
                    GitDeleteBranchOperation.this.deleteTrackedBranchInBackground();
                }
            });
        }
        this.myNotifier.notify(notification);
    }

    private static boolean hasOnlyTrackingBranch(@NotNull MultiMap<String, GitRepository> trackedBranches, @NotNull String localBranch) {
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranches", "git4idea/branch/GitDeleteBranchOperation", "hasOnlyTrackingBranch"));
        }
        if (localBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranch", "git4idea/branch/GitDeleteBranchOperation", "hasOnlyTrackingBranch"));
        }
        for (String remoteBranch : trackedBranches.keySet()) {
            for (GitRepository repository : trackedBranches.get((Object)remoteBranch)) {
                if (!ContainerUtil.exists(repository.getBranchTrackInfos(), info -> {
                    if (localBranch == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranch", "git4idea/branch/GitDeleteBranchOperation", "lambda$hasOnlyTrackingBranch$1"));
                    }
                    return !info.getLocalBranch().getName().equals(localBranch) && info.getRemoteBranch().getName().equals(remoteBranch);
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static void refresh(GitRepository ... repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitDeleteBranchOperation", "refresh"));
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (!result2.totalSuccess()) {
            this.myNotifier.notifyError("Error during rollback of branch deletion", result2.getErrorOutputWithReposIndication());
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.branchCreate(repository, this.myBranchName, this.myDeletedBranchTips.get(repository));
            result2.append(repository, res);
            for (String trackedBranch : this.myTrackedBranches.keySet()) {
                GitCommandResult setTrackResult;
                if (!this.myTrackedBranches.get((Object)trackedBranch).contains(repository) || (setTrackResult = this.setUpTracking(repository, this.myBranchName, trackedBranch)).success()) continue;
                LOG.warn("Couldn't set " + this.myBranchName + " to track " + trackedBranch + " in " + repository.getRoot().getName() + ": " + setTrackResult.getErrorOutputAsJoinedString());
            }
            GitDeleteBranchOperation.refresh(repository);
        }
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "doRollback"));
        }
        return gitCompoundResult;
    }

    @NotNull
    private GitCommandResult setUpTracking(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String trackedBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/branch/GitDeleteBranchOperation", "setUpTracking"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitDeleteBranchOperation", "setUpTracking"));
        }
        if (trackedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranch", "git4idea/branch/GitDeleteBranchOperation", "setUpTracking"));
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.BRANCH);
        if (GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository.getVcs().getVersion())) {
            handler.addParameters("--set-upstream-to", trackedBranch, branchName);
        } else {
            handler.addParameters("--set-upstream", branchName, trackedBranch);
        }
        GitCommandResult gitCommandResult = this.myGit.runCommand(handler);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "setUpTracking"));
        }
        return gitCommandResult;
    }

    @NotNull
    private String getErrorTitle() {
        String string = String.format("Branch %s wasn't deleted", this.myBranchName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getErrorTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = String.format("Deleted branch %s", GitDeleteBranchOperation.formatBranchName(this.myBranchName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getSuccessMessage"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However branch deletion has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (recreate " + this.myBranchName + " in these roots) not to let branches diverge.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getRollbackProposal"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("branch deletion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getOperationName"));
        }
        return "branch deletion";
    }

    @NotNull
    private static String formatBranchName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitDeleteBranchOperation", "formatBranchName"));
        }
        String string = "<b><code>" + name + "</code></b>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "formatBranchName"));
        }
        return string;
    }

    private boolean showNotFullyMergedDialog(@NotNull Map<GitRepository, UnmergedBranchInfo> unmergedBranches) {
        if (unmergedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmergedBranches", "git4idea/branch/GitDeleteBranchOperation", "showNotFullyMergedDialog"));
        }
        HashMap<GitRepository, List<GitCommit>> history = new HashMap<GitRepository, List<GitCommit>>();
        for (GitRepository repository : this.getRepositories()) {
            if (unmergedBranches.containsKey(repository)) {
                UnmergedBranchInfo unmergedInfo = unmergedBranches.get(repository);
                history.put(repository, GitDeleteBranchOperation.getUnmergedCommits(repository, unmergedInfo.myTipOfDeletedUnmergedBranch, unmergedInfo.myBaseBranch));
                continue;
            }
            history.put(repository, Collections.emptyList());
        }
        Map baseBranches = Maps.asMap(unmergedBranches.keySet(), it -> {
            if (unmergedBranches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmergedBranches", "git4idea/branch/GitDeleteBranchOperation", "lambda$showNotFullyMergedDialog$2"));
            }
            return ((UnmergedBranchInfo)unmergedBranches.get(it)).myBaseBranch;
        });
        return this.myUiHandler.showBranchIsNotFullyMergedDialog(this.myProject, history, baseBranches, this.myBranchName);
    }

    @NotNull
    private static List<GitCommit> getUnmergedCommits(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String baseBranch) {
        List<GitCommit> list;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/branch/GitDeleteBranchOperation", "getUnmergedCommits"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitDeleteBranchOperation", "getUnmergedCommits"));
        }
        if (baseBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/branch/GitDeleteBranchOperation", "getUnmergedCommits"));
        }
        String range = baseBranch + ".." + branchName;
        try {
            list = GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get `git log " + range + "` in " + DvcsUtil.getShortRepositoryName((Repository)repository), (Throwable)e);
            List<GitCommit> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getUnmergedCommits"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "getUnmergedCommits"));
        }
        return list;
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByTrackedBranchName(@NotNull String branchName, @NotNull Collection<GitRepository> repositories) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitDeleteBranchOperation", "groupByTrackedBranchName"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitDeleteBranchOperation", "groupByTrackedBranchName"));
        }
        MultiMap trackedBranchNames = MultiMap.createLinked();
        for (GitRepository repository : repositories) {
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfo(repository, branchName);
            if (trackInfo == null) continue;
            trackedBranchNames.putValue((Object)trackInfo.getRemoteBranch().getNameForLocalOperations(), (Object)repository);
        }
        MultiMap multiMap = trackedBranchNames;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitDeleteBranchOperation", "groupByTrackedBranchName"));
        }
        return multiMap;
    }

    private void deleteTrackedBranchInBackground() {
        new Task.Backgroundable(this.myProject, "Deleting Remote Branch " + this.myBranchName + "..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$4", "run"));
                }
                GitBrancher brancher = GitBrancher.getInstance(this.getProject());
                for (String remoteBranch : GitDeleteBranchOperation.this.myTrackedBranches.keySet()) {
                    brancher.deleteRemoteBranch(remoteBranch, new ArrayList<GitRepository>(GitDeleteBranchOperation.this.myTrackedBranches.get((Object)remoteBranch)));
                }
            }
        }.queue();
    }

    private void restoreInBackground(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation", "restoreInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Restoring Branch " + this.myBranchName + "..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$5", "run"));
                }
                GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
            }
        }.queue();
    }

    private void rollbackBranchDeletion(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation", "rollbackBranchDeletion"));
        }
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            notification.expire();
        } else {
            this.myNotifier.notifyError("Couldn't Restore " + GitDeleteBranchOperation.formatBranchName(this.myBranchName), result2.getErrorOutputWithReposIndication());
        }
    }

    private void viewUnmergedCommitsInBackground(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitDeleteBranchOperation", "viewUnmergedCommitsInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Collecting Unmerged Commits..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteBranchOperation$6", "run"));
                }
                boolean restore = GitDeleteBranchOperation.this.showNotFullyMergedDialog(GitDeleteBranchOperation.this.myUnmergedToBranches);
                if (restore) {
                    GitDeleteBranchOperation.this.rollbackBranchDeletion(notification);
                }
            }
        }.queue();
    }

    static class UnmergedBranchInfo {
        @NotNull
        private final String myTipOfDeletedUnmergedBranch;
        @NotNull
        private final String myBaseBranch;

        public UnmergedBranchInfo(@NotNull String tipOfDeletedUnmergedBranch, @NotNull String baseBranch) {
            if (tipOfDeletedUnmergedBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tipOfDeletedUnmergedBranch", "git4idea/branch/GitDeleteBranchOperation$UnmergedBranchInfo", "<init>"));
            }
            if (baseBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/branch/GitDeleteBranchOperation$UnmergedBranchInfo", "<init>"));
            }
            this.myTipOfDeletedUnmergedBranch = tipOfDeletedUnmergedBranch;
            this.myBaseBranch = baseBranch;
        }
    }

    private static class GitBranchNotMergedToUpstreamDetector
    implements GitLineHandlerListener {
        private static final Pattern PATTERN = Pattern.compile(".*'(.*)', even though it is merged to.*");
        @Nullable
        private String myBaseBranch;

        private GitBranchNotMergedToUpstreamDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myBaseBranch = matcher.group(1);
            }
        }

        public void processTerminated(int exitCode) {
        }

        public void startFailed(Throwable exception) {
        }

        @Nullable
        public String getBaseBranch() {
            return this.myBaseBranch;
        }
    }
}

