/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckoutProvider
extends CheckoutProviderEx {
    private final Git myGit;

    public GitCheckoutProvider(@NotNull Git git) {
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/checkout/GitCheckoutProvider", "<init>"));
        }
        this.myGit = git;
    }

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener2, @Nullable String predefinedRepositoryUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCheckoutProvider", "doCheckout"));
        }
        BasicAction.saveAll();
        GitCloneDialog dialog = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        String directoryName = dialog.getDirectoryName();
        String parentDirectory = dialog.getParentDirectory();
        GitCheckoutProvider.clone(project, this.myGit, listener2, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final @NotNull Git git, final CheckoutProvider.Listener listener2, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/checkout/GitCheckoutProvider", "clone"));
        }
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/checkout/GitCheckoutProvider$1", "run"));
                }
                cloneResult.set(GitCheckoutProvider.doClone(project, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"Git");
                destinationParent.refresh(true, true, () -> {
                    if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                        mgr.fileDirty(destinationParent);
                    }
                });
                listener2.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener2.checkoutCompleted();
            }
        }.queue();
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (parentDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDirectory", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        if (sourceRepositoryURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRepositoryURL", "git4idea/checkout/GitCheckoutProvider", "doClone"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", result2.getErrorOutputAsHtmlString());
        return false;
    }

    @NotNull
    public String getVcsId() {
        if ("git" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkout/GitCheckoutProvider", "getVcsId"));
        }
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkout/GitCheckoutProvider", "doCheckout"));
        }
        this.doCheckout(project, listener2, null);
    }
}

