/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitCommand {
    public static final GitCommand ADD = GitCommand.write("add");
    public static final GitCommand BLAME = GitCommand.read("blame");
    public static final GitCommand BRANCH = GitCommand.read("branch");
    public static final GitCommand CHECKOUT = GitCommand.write("checkout");
    public static final GitCommand CHECK_ATTR = GitCommand.read("check-attr");
    public static final GitCommand COMMIT = GitCommand.write("commit");
    public static final GitCommand CONFIG = GitCommand.read("config");
    public static final GitCommand CHERRY = GitCommand.read("cherry");
    public static final GitCommand CHERRY_PICK = GitCommand.write("cherry-pick");
    public static final GitCommand CLONE = GitCommand.write("clone");
    public static final GitCommand DIFF = GitCommand.read("diff");
    public static final GitCommand FETCH = GitCommand.read("fetch");
    public static final GitCommand INIT = GitCommand.write("init");
    public static final GitCommand LOG = GitCommand.read("log");
    public static final GitCommand LS_FILES = GitCommand.read("ls-files");
    public static final GitCommand LS_TREE = GitCommand.read("ls-tree");
    public static final GitCommand LS_REMOTE = GitCommand.read("ls-remote");
    public static final GitCommand MERGE = GitCommand.write("merge");
    public static final GitCommand MERGE_BASE = GitCommand.read("merge-base");
    public static final GitCommand MV = GitCommand.write("mv");
    public static final GitCommand PULL = GitCommand.write("pull");
    public static final GitCommand PUSH = GitCommand.write("push");
    public static final GitCommand REBASE = GitCommand.write("rebase");
    public static final GitCommand REMOTE = GitCommand.read("remote");
    public static final GitCommand RESET = GitCommand.write("reset");
    public static final GitCommand REVERT = GitCommand.write("revert");
    public static final GitCommand REV_LIST = GitCommand.read("rev-list");
    public static final GitCommand REV_PARSE = GitCommand.read("rev-parse");
    public static final GitCommand RM = GitCommand.write("rm");
    public static final GitCommand SHOW = GitCommand.read("show");
    public static final GitCommand STASH = GitCommand.write("stash");
    public static final GitCommand STATUS = Registry.is((String)"git.status.write") ? GitCommand.write("status") : GitCommand.read("status");
    public static final GitCommand TAG = GitCommand.read("tag");
    public static final GitCommand UPDATE_INDEX = GitCommand.write("update-index");
    public static final String GIT_EDITOR_ENV = "GIT_EDITOR";
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final LockingPolicy myLocking;

    private GitCommand(@NotNull String name, @NotNull LockingPolicy lockingPolicy) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/commands/GitCommand", "<init>"));
        }
        if (lockingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockingPolicy", "git4idea/commands/GitCommand", "<init>"));
        }
        this.myLocking = lockingPolicy;
        this.myName = name;
    }

    private GitCommand(@NotNull GitCommand command, @NotNull LockingPolicy lockingPolicy) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitCommand", "<init>"));
        }
        if (lockingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lockingPolicy", "git4idea/commands/GitCommand", "<init>"));
        }
        this.myName = command.name();
        this.myLocking = lockingPolicy;
    }

    @NotNull
    public GitCommand readLockingCommand() {
        GitCommand gitCommand = new GitCommand(this, LockingPolicy.READ);
        if (gitCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "readLockingCommand"));
        }
        return gitCommand;
    }

    @NotNull
    public GitCommand writeLockingCommand() {
        GitCommand gitCommand = new GitCommand(this, LockingPolicy.WRITE);
        if (gitCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "writeLockingCommand"));
        }
        return gitCommand;
    }

    @NotNull
    private static GitCommand read(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/commands/GitCommand", "read"));
        }
        GitCommand gitCommand = new GitCommand(name, LockingPolicy.READ);
        if (gitCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "read"));
        }
        return gitCommand;
    }

    @NotNull
    private static GitCommand write(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/commands/GitCommand", "write"));
        }
        GitCommand gitCommand = new GitCommand(name, LockingPolicy.WRITE);
        if (gitCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "write"));
        }
        return gitCommand;
    }

    @NotNull
    public String name() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "name"));
        }
        return string;
    }

    @NotNull
    public LockingPolicy lockingPolicy() {
        LockingPolicy lockingPolicy = this.myLocking;
        if (lockingPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommand", "lockingPolicy"));
        }
        return lockingPolicy;
    }

    public String toString() {
        return this.myName;
    }

    static enum LockingPolicy {
        READ,
        WRITE;

    }
}

