/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.util.GitUIUtil;
import java.awt.EventQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHandlerUtil {
    private GitHandlerUtil() {
    }

    @Nullable
    public static String doSynchronously(final GitSimpleHandler handler, String operationTitle, @NonNls String operationName) {
        handler.addListener(new GitHandlerListenerBase((GitHandler)handler, operationName){

            @Override
            protected String getErrorText() {
                String text = handler.getStderr();
                if (text.length() == 0) {
                    text = handler.getStdout();
                }
                return text;
            }
        });
        ProgressManager manager = ProgressManager.getInstance();
        manager.runProcessWithProgressSynchronously(() -> GitHandlerUtil.runInCurrentThread(handler, manager.getProgressIndicator(), true, operationTitle), operationTitle, false, handler.project());
        if (!handler.isStarted() || handler.getExitCode() != 0) {
            return null;
        }
        return handler.getStdout();
    }

    public static int doSynchronously(final GitLineHandler handler, final String operationTitle, final @NonNls String operationName) {
        ProgressManager manager = ProgressManager.getInstance();
        manager.run((Task)new Task.Modal(handler.project(), operationTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/commands/GitHandlerUtil$2", "run"));
                }
                handler.addLineListener(new GitLineHandlerListenerProgress(indicator, handler, operationName, true));
                GitHandlerUtil.runInCurrentThread(handler, indicator, true, operationTitle);
            }
        });
        if (!handler.isStarted()) {
            return -1;
        }
        return handler.getExitCode();
    }

    public static void runInCurrentThread(GitHandler handler, ProgressIndicator indicator, boolean setIndeterminateFlag, @Nullable String operationName) {
        GitHandlerUtil.runInCurrentThread(handler, () -> {
            if (indicator != null) {
                indicator.setText(operationName == null ? GitBundle.message("git.running", handler.printableCommandLine()) : operationName);
                indicator.setText2("");
                if (setIndeterminateFlag) {
                    indicator.setIndeterminate(true);
                }
            }
        });
    }

    public static void runInCurrentThread(GitHandler handler, @Nullable Runnable postStartAction) {
        handler.runInCurrentThread(postStartAction);
    }

    public static String formatOperationName(String operation, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/commands/GitHandlerUtil", "formatOperationName"));
        }
        return operation + " '" + root.getName() + "'...";
    }

    protected static boolean isErrorLine(String text) {
        for (String prefix : GitImpl.ERROR_INDICATORS) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static class GitLineHandlerListenerProgress
    extends GitLineHandlerListenerBase {
        @Nullable
        private final ProgressIndicator myProgressIndicator;

        public GitLineHandlerListenerProgress(@Nullable ProgressIndicator indicator, GitHandler handler, String operationName, boolean showErrors) {
            super(handler, operationName, showErrors);
            this.myProgressIndicator = indicator;
        }

        @Override
        protected String getErrorText() {
            return "";
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (GitHandlerUtil.isErrorLine(line.trim())) {
                this.myHandler.addError(new VcsException(line));
            }
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText2(line);
            }
        }
    }

    private static abstract class GitLineHandlerListenerBase
    extends GitHandlerListenerBase
    implements GitLineHandlerListener {
        public GitLineHandlerListenerBase(GitHandler handler, String operationName, boolean showErrors) {
            super(handler, operationName, showErrors);
        }
    }

    private static abstract class GitHandlerListenerBase
    implements GitHandlerListener {
        protected final GitHandler myHandler;
        protected final String myOperationName;
        protected boolean myShowErrors;

        public GitHandlerListenerBase(GitHandler handler, String operationName) {
            this(handler, operationName, true);
        }

        public GitHandlerListenerBase(GitHandler handler, String operationName, boolean showErrors) {
            this.myHandler = handler;
            this.myOperationName = operationName;
            this.myShowErrors = showErrors;
        }

        public void processTerminated(int exitCode) {
            if (exitCode != 0 && !this.myHandler.isIgnoredErrorCode(exitCode)) {
                this.ensureError(exitCode);
                if (this.myShowErrors) {
                    EventQueue.invokeLater(() -> GitUIUtil.showOperationErrors(this.myHandler.project(), this.myHandler.errors(), this.myOperationName));
                }
            }
        }

        protected void ensureError(int exitCode) {
            if (this.myHandler.errors().isEmpty()) {
                String text = this.getErrorText();
                if ((text == null || text.length() == 0) && this.myHandler.errors().isEmpty()) {
                    this.myHandler.addError(new VcsException(GitBundle.message("git.error.exit", exitCode)));
                } else {
                    this.myHandler.addError(new VcsException(text));
                }
            }
        }

        protected abstract String getErrorText();

        public void startFailed(Throwable exception) {
            this.myHandler.addError(new VcsException("Git start failed: " + exception.getMessage(), exception));
            if (this.myShowErrors) {
                EventQueue.invokeLater(() -> GitUIUtil.showOperationError(this.myHandler.project(), this.myOperationName, exception.getMessage()));
            }
        }
    }
}

