/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import git4idea.config.GitExecutableDetector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Application.Settings", storages={@Storage(value="git.xml", roamingType=RoamingType.PER_OS), @Storage(value="vcs.xml", deprecated=true)})
public class GitVcsApplicationSettings
implements PersistentStateComponent<State> {
    private State myState = new State();
    @Nullable
    private String myDetectedPathToGit;

    public static GitVcsApplicationSettings getInstance() {
        return (GitVcsApplicationSettings)ServiceManager.getService(GitVcsApplicationSettings.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @NotNull
    public String getPathToGit() {
        if (this.myState.myPathToGit == null) {
            if (this.myDetectedPathToGit == null) {
                this.myDetectedPathToGit = new GitExecutableDetector().detect();
            }
            String string = this.myDetectedPathToGit;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsApplicationSettings", "getPathToGit"));
            }
            return string;
        }
        String string = this.myState.myPathToGit;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsApplicationSettings", "getPathToGit"));
        }
        return string;
    }

    public void setPathToGit(@Nullable String pathToGit) {
        this.myState.myPathToGit = pathToGit;
    }

    public void setIdeaSsh(@NotNull SshExecutable executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "git4idea/config/GitVcsApplicationSettings", "setIdeaSsh"));
        }
        this.myState.SSH_EXECUTABLE = executable;
    }

    @Nullable
    SshExecutable getIdeaSsh() {
        return this.myState.SSH_EXECUTABLE;
    }

    public static class State {
        public String myPathToGit = null;
        public SshExecutable SSH_EXECUTABLE = null;
    }

    public static enum SshExecutable {
        IDEA_SSH,
        NATIVE_SSH;

    }
}

