/*
 * Decompiled with CFR 0.152.
 */
package git4idea.crlf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.attributes.GitAttribute;
import git4idea.attributes.GitCheckAttrParser;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCrlfProblemsDetector {
    private static final Logger LOG = Logger.getInstance(GitCrlfProblemsDetector.class);
    private static final String CRLF = "\r\n";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    private final boolean myShouldWarn;

    @NotNull
    public static GitCrlfProblemsDetector detect(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/crlf/GitCrlfProblemsDetector", "detect"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/crlf/GitCrlfProblemsDetector", "detect"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/crlf/GitCrlfProblemsDetector", "detect"));
        }
        GitCrlfProblemsDetector gitCrlfProblemsDetector = new GitCrlfProblemsDetector(project, git, files);
        if (gitCrlfProblemsDetector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "detect"));
        }
        return gitCrlfProblemsDetector;
    }

    private GitCrlfProblemsDetector(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        Map<VirtualFile, Collection<VirtualFile>> crlfFilesByRoots;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/crlf/GitCrlfProblemsDetector", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/crlf/GitCrlfProblemsDetector", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/crlf/GitCrlfProblemsDetector", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
        this.myGit = git;
        Map<VirtualFile, List<VirtualFile>> filesByRoots = GitCrlfProblemsDetector.sortFilesByRoots(files);
        boolean shouldWarn = false;
        Collection<VirtualFile> rootsWithIncorrectAutoCrlf = this.getRootsWithIncorrectAutoCrlf(filesByRoots);
        if (!rootsWithIncorrectAutoCrlf.isEmpty() && !(crlfFilesByRoots = this.findFilesWithCrlf(filesByRoots, rootsWithIncorrectAutoCrlf)).isEmpty()) {
            Map<VirtualFile, Collection<VirtualFile>> crlfFilesWithoutAttrsByRoots = this.findFilesWithoutAttrs(crlfFilesByRoots);
            shouldWarn = !crlfFilesWithoutAttrsByRoots.isEmpty();
        }
        this.myShouldWarn = shouldWarn;
    }

    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithoutAttrs(Map<VirtualFile, Collection<VirtualFile>> filesByRoots) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithoutAttrsByRoot = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : filesByRoots.entrySet()) {
            Collection<VirtualFile> files;
            VirtualFile root = entry.getKey();
            Collection<VirtualFile> filesWithoutAttrs = this.findFilesWithoutAttrs(root, files = entry.getValue());
            if (filesWithoutAttrs.isEmpty()) continue;
            filesWithoutAttrsByRoot.put(root, filesWithoutAttrs);
        }
        return filesWithoutAttrsByRoot;
    }

    @NotNull
    private Collection<VirtualFile> findFilesWithoutAttrs(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithoutAttrs"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithoutAttrs"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithoutAttrs"));
            }
            return list;
        }
        List<String> interestingAttributes = Arrays.asList(GitAttribute.TEXT.getName(), GitAttribute.CRLF.getName());
        GitCommandResult result2 = this.myGit.checkAttr(repository, interestingAttributes, files);
        if (!result2.success()) {
            LOG.warn(String.format("Couldn't git check-attr. Attributes: %s, files: %s", interestingAttributes, files));
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithoutAttrs"));
            }
            return list;
        }
        GitCheckAttrParser parser = GitCheckAttrParser.parse(result2.getOutput());
        Map<String, Collection<GitAttribute>> attributes = parser.getAttributes();
        ArrayList<VirtualFile> filesWithoutAttrs = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            ProgressIndicatorProvider.checkCanceled();
            String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)'/');
            Collection<GitAttribute> attrs = attributes.get(relativePath);
            if (attrs != null && (attrs.contains((Object)GitAttribute.TEXT) || attrs.contains((Object)GitAttribute.CRLF))) continue;
            filesWithoutAttrs.add(file);
        }
        ArrayList<VirtualFile> arrayList = filesWithoutAttrs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithoutAttrs"));
        }
        return arrayList;
    }

    @NotNull
    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> allFilesByRoots, @NotNull Collection<VirtualFile> rootsWithIncorrectAutoCrlf) {
        if (allFilesByRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFilesByRoots", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithCrlf"));
        }
        if (rootsWithIncorrectAutoCrlf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsWithIncorrectAutoCrlf", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithCrlf"));
        }
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithCrlfByRoots = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : allFilesByRoots.entrySet()) {
            Collection<VirtualFile> filesWithCrlf;
            VirtualFile root = entry.getKey();
            List<VirtualFile> files = entry.getValue();
            if (!rootsWithIncorrectAutoCrlf.contains(root) || (filesWithCrlf = this.findFilesWithCrlf(files)).isEmpty()) continue;
            filesWithCrlfByRoots.put(root, filesWithCrlf);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> hashMap = filesWithCrlfByRoots;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithCrlf"));
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findFilesWithCrlf(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithCrlf"));
        }
        ArrayList<VirtualFile> filesWithCrlf = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            ProgressIndicatorProvider.checkCanceled();
            String separator = LoadTextUtil.detectLineSeparator((VirtualFile)file, (boolean)true);
            if (!CRLF.equals(separator)) continue;
            filesWithCrlf.add(file);
        }
        ArrayList<VirtualFile> arrayList = filesWithCrlf;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "findFilesWithCrlf"));
        }
        return arrayList;
    }

    @NotNull
    private Collection<VirtualFile> getRootsWithIncorrectAutoCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> filesByRoots) {
        if (filesByRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesByRoots", "git4idea/crlf/GitCrlfProblemsDetector", "getRootsWithIncorrectAutoCrlf"));
        }
        ArrayList<VirtualFile> rootsWithIncorrectAutoCrlf = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : filesByRoots.entrySet()) {
            VirtualFile root = entry.getKey();
            boolean autocrlf = this.isAutoCrlfSetRight(root);
            if (autocrlf) continue;
            rootsWithIncorrectAutoCrlf.add(root);
        }
        ArrayList<VirtualFile> arrayList = rootsWithIncorrectAutoCrlf;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "getRootsWithIncorrectAutoCrlf"));
        }
        return arrayList;
    }

    private boolean isAutoCrlfSetRight(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/crlf/GitCrlfProblemsDetector", "isAutoCrlfSetRight"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            return true;
        }
        GitCommandResult result2 = this.myGit.config(repository, "core.autocrlf");
        String value = result2.getOutputAsJoinedString();
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("input");
    }

    @NotNull
    private static Map<VirtualFile, List<VirtualFile>> sortFilesByRoots(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/crlf/GitCrlfProblemsDetector", "sortFilesByRoots"));
        }
        Map<VirtualFile, List<VirtualFile>> map = GitUtil.sortFilesByGitRootsIgnoringOthers(files);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfProblemsDetector", "sortFilesByRoots"));
        }
        return map;
    }

    public boolean shouldWarn() {
        return this.myShouldWarn;
    }
}

