/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.GitHandler;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecord {
    private static final Logger LOG = Logger.getInstance(GitLogRecord.class);
    @NotNull
    private final Map<GitLogParser.GitLogOption, String> myOptions;
    @NotNull
    private final List<String> myPaths;
    @NotNull
    private final List<GitLogStatusInfo> myStatusInfo;
    private final boolean mySupportsRawBody;
    private GitHandler myHandler;

    GitLogRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, @NotNull List<String> paths, @NotNull List<GitLogStatusInfo> statusInfo, boolean supportsRawBody) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "git4idea/history/GitLogRecord", "<init>"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "git4idea/history/GitLogRecord", "<init>"));
        }
        if (statusInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusInfo", "git4idea/history/GitLogRecord", "<init>"));
        }
        this.myOptions = options;
        this.myPaths = paths;
        this.myStatusInfo = statusInfo;
        this.mySupportsRawBody = supportsRawBody;
    }

    @NotNull
    private List<String> getPaths() {
        List<String> list = this.myPaths;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getPaths"));
        }
        return list;
    }

    @NotNull
    List<GitLogStatusInfo> getStatusInfos() {
        List<GitLogStatusInfo> list = this.myStatusInfo;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getStatusInfos"));
        }
        return list;
    }

    @NotNull
    public List<FilePath> getFilePaths(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogRecord", "getFilePaths"));
        }
        ArrayList<FilePath> res = new ArrayList<FilePath>();
        String prefix = root.getPath() + "/";
        for (String strPath : this.getPaths()) {
            String subPath = GitUtil.unescapePath(strPath);
            FilePath revisionPath = VcsUtil.getFilePath((String)(prefix + subPath), (boolean)false);
            res.add(revisionPath);
        }
        ArrayList<FilePath> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getFilePaths"));
        }
        return arrayList;
    }

    @NotNull
    private String lookup(@NotNull GitLogParser.GitLogOption key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "git4idea/history/GitLogRecord", "lookup"));
        }
        String value = this.myOptions.get((Object)key);
        if (value == null) {
            LOG.error("Missing value for option " + (Object)((Object)key));
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "lookup"));
            }
            return "";
        }
        String string = GitLogRecord.shortBuffer(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "lookup"));
        }
        return string;
    }

    @NotNull
    String getHash() {
        String string = this.lookup(GitLogParser.GitLogOption.HASH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getHash"));
        }
        return string;
    }

    @NotNull
    String getTreeHash() {
        String string = this.lookup(GitLogParser.GitLogOption.TREE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getTreeHash"));
        }
        return string;
    }

    @NotNull
    String getAuthorName() {
        String string = this.lookup(GitLogParser.GitLogOption.AUTHOR_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getAuthorName"));
        }
        return string;
    }

    @NotNull
    String getAuthorEmail() {
        String string = this.lookup(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getAuthorEmail"));
        }
        return string;
    }

    @NotNull
    String getCommitterName() {
        String string = this.lookup(GitLogParser.GitLogOption.COMMITTER_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getCommitterName"));
        }
        return string;
    }

    @NotNull
    String getCommitterEmail() {
        String string = this.lookup(GitLogParser.GitLogOption.COMMITTER_EMAIL);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getCommitterEmail"));
        }
        return string;
    }

    @NotNull
    String getSubject() {
        String string = this.lookup(GitLogParser.GitLogOption.SUBJECT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getSubject"));
        }
        return string;
    }

    @NotNull
    String getBody() {
        String string = this.lookup(GitLogParser.GitLogOption.BODY);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getBody"));
        }
        return string;
    }

    @NotNull
    String getRawBody() {
        String string = this.lookup(GitLogParser.GitLogOption.RAW_BODY);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getRawBody"));
        }
        return string;
    }

    @NotNull
    String getShortenedRefLog() {
        String string = this.lookup(GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getShortenedRefLog"));
        }
        return string;
    }

    @NotNull
    Date getDate() {
        Date date = new Date(this.getCommitTime());
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getDate"));
        }
        return date;
    }

    long getCommitTime() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.COMMIT_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get commit time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    long getAuthorTimeStamp() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.AUTHOR_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get author time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    String getFullMessage() {
        return this.mySupportsRawBody ? this.getRawBody().trim() : (this.getSubject() + "\n\n" + this.getBody()).trim();
    }

    @NotNull
    String[] getParentsHashes() {
        String parents = this.lookup(GitLogParser.GitLogOption.PARENTS);
        if (parents.trim().length() == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getParentsHashes"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = parents.split(" ");
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getParentsHashes"));
        }
        return stringArray;
    }

    @NotNull
    public Collection<String> getRefs() {
        String decorate = this.myOptions.get((Object)GitLogParser.GitLogOption.REF_NAMES);
        List<String> list = GitLogRecord.parseRefNames(decorate);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getRefs"));
        }
        return list;
    }

    @NotNull
    public Map<GitLogParser.GitLogOption, String> getOptions() {
        Map<GitLogParser.GitLogOption, String> map = this.myOptions;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "getOptions"));
        }
        return map;
    }

    public boolean isSupportsRawBody() {
        return this.mySupportsRawBody;
    }

    @NotNull
    private static List<String> parseRefNames(@Nullable String decoration) {
        if (decoration == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "parseRefNames"));
            }
            return list;
        }
        int startParentheses = decoration.indexOf("(");
        int endParentheses = decoration.indexOf(")");
        if (startParentheses == -1 || endParentheses == -1) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "parseRefNames"));
            }
            return list;
        }
        String refs = decoration.substring(startParentheses + 1, endParentheses);
        String[] names = refs.split(", ");
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String item : names) {
            String POINTER = " -> ";
            if (item.contains(" -> ")) {
                List parts = StringUtil.split((String)item, (String)" -> ");
                result2.addAll(ContainerUtil.map((Collection)parts, s -> GitLogRecord.shortBuffer(s.trim())));
                continue;
            }
            int colon = item.indexOf(58);
            result2.add(GitLogRecord.shortBuffer(colon > 0 ? item.substring(colon + 1).trim() : item));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "parseRefNames"));
        }
        return arrayList;
    }

    @NotNull
    private static String shortBuffer(@NotNull String raw) {
        if (raw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "raw", "git4idea/history/GitLogRecord", "shortBuffer"));
        }
        String string = new String(raw);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "shortBuffer"));
        }
        return string;
    }

    @NotNull
    public List<Change> parseChanges(@NotNull Project project, @NotNull VirtualFile vcsRoot) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogRecord", "parseChanges"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/history/GitLogRecord", "parseChanges"));
        }
        List<Change> list = GitChangesParser.parse(project, vcsRoot, this.myStatusInfo, this.getHash(), this.getDate(), Arrays.asList(this.getParentsHashes()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecord", "parseChanges"));
        }
        return list;
    }

    public void setUsedHandler(GitHandler handler) {
        this.myHandler = handler;
    }

    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, myPaths=%s, myStatusInfo=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.myPaths, this.myStatusInfo, this.mySupportsRawBody, this.myHandler);
    }
}

