/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitHistoryUtils;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class GitLogRecordCollector
implements Consumer<GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToRecord;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogRecordCollector", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogRecordCollector", "<init>"));
        }
        this.myHashToRecord = MultiMap.createLinked();
        this.myProject = project;
        this.myRoot = root;
    }

    public void consume(@NotNull GitLogRecord record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitLogRecordCollector", "consume"));
        }
        String[] parents = record.getParentsHashes();
        if (parents.length <= 1) {
            this.consume(Collections.singletonList(record));
        } else {
            this.myHashToRecord.putValue((Object)record.getHash(), (Object)record);
            if (parents.length == this.myHashToRecord.get((Object)record.getHash()).size()) {
                this.processCollectedRecords();
            }
        }
    }

    private void processCollectedRecords() {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToRecord.get((Object)hash))));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length && !this.fillWithEmptyRecords(records)) continue;
            this.consume(records);
        }
        this.myHashToRecord.clear();
    }

    public void finish() {
        this.processCollectedRecords();
    }

    public abstract void consume(@NotNull List<GitLogRecord> var1);

    private boolean fillWithEmptyRecords(@NotNull List<GitLogRecord> records) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogRecordCollector", "fillWithEmptyRecords"));
        }
        GitLogRecord firstRecord = records.get(0);
        String commit = firstRecord.getHash();
        Object[] parents = firstRecord.getParentsHashes();
        ArrayList hashes2 = ContainerUtil.newArrayList((Object[])parents);
        hashes2.add(commit);
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(this.myProject, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitHistoryUtils.formHashParameters((GitVcs)((Object)ObjectUtils.notNull((Object)((Object)GitVcs.getInstance(this.myProject)))), hashes2));
        handler.endOptions();
        try {
            String output = handler.run();
            List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
            Map hashToTreeMap = ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
            String commitTreeHash = (String)hashToTreeMap.get(commit);
            LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit));
            for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
                Object parent = parents[parentIndex];
                String parentTreeHash = (String)hashToTreeMap.get(parent);
                LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + (String)parent));
                if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
                records.add(parentIndex, new GitLogRecord(firstRecord.getOptions(), ContainerUtil.emptyList(), ContainerUtil.emptyList(), firstRecord.isSupportsRawBody()));
            }
        }
        catch (VcsException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }
}

