/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitMerger {
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;

    public GitMerger(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/merge/GitMerger", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public Collection<VirtualFile> getMergingRoots() {
        Collection<VirtualFile> collection = GitUtil.getRootsFromRepositories(ContainerUtil.filter(this.myRepositoryManager.getRepositories(), repository -> repository.getState() == Repository.State.MERGING));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/merge/GitMerger", "getMergingRoots"));
        }
        return collection;
    }

    public void mergeCommit(@NotNull Collection<VirtualFile> roots) throws VcsException {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/merge/GitMerger", "mergeCommit"));
        }
        for (VirtualFile root : roots) {
            this.mergeCommit(root);
        }
    }

    public void mergeCommit(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/merge/GitMerger", "mergeCommit"));
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        File messageFile = ((GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root))).getRepositoryFiles().getMergeMessageFile();
        if (!messageFile.exists()) {
            GitLocalBranch branch = GitBranchUtil.getCurrentBranch(this.myProject, root);
            String branchName = branch != null ? branch.getName() : "";
            handler.addParameters("-m", "Merge branch '" + branchName + "' of " + root.getPresentableUrl() + " with conflicts.");
        } else {
            handler.addParameters("-F", messageFile.getAbsolutePath());
        }
        handler.endOptions();
        handler.run();
    }
}

