/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitSubmoduleInfo;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepoInfo {
    @Nullable
    private final GitLocalBranch myCurrentBranch;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @NotNull
    private final Set<GitRemote> myRemotes;
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;
    @NotNull
    private final Set<GitBranchTrackInfo> myBranchTrackInfos;
    @NotNull
    private final Collection<GitSubmoduleInfo> mySubmodules;
    @NotNull
    private final GitHooksInfo myHooksInfo;

    public GitRepoInfo(@Nullable GitLocalBranch currentBranch, @Nullable String currentRevision, @NotNull Repository.State state, @NotNull Collection<GitRemote> remotes, @NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches, @NotNull Collection<GitBranchTrackInfo> branchTrackInfos, @NotNull Collection<GitSubmoduleInfo> submodules, @NotNull GitHooksInfo hooksInfo) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranches", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (branchTrackInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchTrackInfos", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (submodules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "submodules", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (hooksInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hooksInfo", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myState = state;
        this.myRemotes = new LinkedHashSet<GitRemote>(remotes);
        this.myLocalBranches = new LinkedHashMap<GitLocalBranch, Hash>(localBranches);
        this.myRemoteBranches = new LinkedHashMap<GitRemoteBranch, Hash>(remoteBranches);
        this.myBranchTrackInfos = new LinkedHashSet<GitBranchTrackInfo>(branchTrackInfos);
        this.mySubmodules = submodules;
        this.myHooksInfo = hooksInfo;
    }

    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public Collection<GitRemote> getRemotes() {
        Set<GitRemote> set = this.myRemotes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getRemotes"));
        }
        return set;
    }

    @NotNull
    public Map<GitLocalBranch, Hash> getLocalBranchesWithHashes() {
        Map<GitLocalBranch, Hash> map = this.myLocalBranches;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getLocalBranchesWithHashes"));
        }
        return map;
    }

    @NotNull
    public Map<GitRemoteBranch, Hash> getRemoteBranchesWithHashes() {
        Map<GitRemoteBranch, Hash> map = this.myRemoteBranches;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getRemoteBranchesWithHashes"));
        }
        return map;
    }

    @Deprecated
    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Set<GitRemoteBranch> set = this.myRemoteBranches.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getRemoteBranches"));
        }
        return set;
    }

    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Set<GitBranchTrackInfo> set = this.myBranchTrackInfos;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getBranchTrackInfos"));
        }
        return set;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getState"));
        }
        return state;
    }

    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        Collection<GitSubmoduleInfo> collection = this.mySubmodules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getSubmodules"));
        }
        return collection;
    }

    @NotNull
    public GitHooksInfo getHooksInfo() {
        GitHooksInfo gitHooksInfo = this.myHooksInfo;
        if (gitHooksInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getHooksInfo"));
        }
        return gitHooksInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepoInfo info = (GitRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (this.myCurrentBranch != null ? !this.myCurrentBranch.equals(info.myCurrentBranch) : info.myCurrentBranch != null) {
            return false;
        }
        if (!this.myRemotes.equals(info.myRemotes)) {
            return false;
        }
        if (!this.myBranchTrackInfos.equals(info.myBranchTrackInfos)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myLocalBranches, info.myLocalBranches)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myRemoteBranches, info.myRemoteBranches)) {
            return false;
        }
        if (!this.mySubmodules.equals(info.mySubmodules)) {
            return false;
        }
        return this.myHooksInfo.equals(info.myHooksInfo);
    }

    public int hashCode() {
        int result2 = this.myCurrentBranch != null ? this.myCurrentBranch.hashCode() : 0;
        result2 = 31 * result2 + (this.myCurrentRevision != null ? this.myCurrentRevision.hashCode() : 0);
        result2 = 31 * result2 + this.myState.hashCode();
        result2 = 31 * result2 + this.myRemotes.hashCode();
        result2 = 31 * result2 + this.myLocalBranches.hashCode();
        result2 = 31 * result2 + this.myRemoteBranches.hashCode();
        result2 = 31 * result2 + this.myBranchTrackInfos.hashCode();
        result2 = 31 * result2 + this.mySubmodules.hashCode();
        result2 = 31 * result2 + this.myHooksInfo.hashCode();
        return result2;
    }

    public String toString() {
        return String.format("GitRepoInfo{current=%s, remotes=%s, localBranches=%s, remoteBranches=%s, trackInfos=%s, submodules=%s, hooks=%s}", this.myCurrentBranch, this.myRemotes, this.myLocalBranches, this.myRemoteBranches, this.myBranchTrackInfos, this.mySubmodules, this.myHooksInfo);
    }

    private static <T extends GitBranch> boolean areEqual(Map<T, Hash> c1, Map<T, Hash> c2) {
        THashSet set1 = new THashSet(c1.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        THashSet set2 = new THashSet(c2.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        return set1.equals((Object)set2);
    }

    private static class BranchesComparingStrategy
    implements TObjectHashingStrategy<Map.Entry<? extends GitBranch, Hash>> {
        private BranchesComparingStrategy() {
        }

        public int computeHashCode(@NotNull Map.Entry<? extends GitBranch, Hash> branchEntry) {
            if (branchEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchEntry", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "computeHashCode"));
            }
            return 31 * branchEntry.getKey().getName().hashCode() + branchEntry.getValue().hashCode();
        }

        public boolean equals(@NotNull Map.Entry<? extends GitBranch, Hash> b1, @NotNull Map.Entry<? extends GitBranch, Hash> b2) {
            if (b1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b1", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "equals"));
            }
            if (b2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b2", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "equals"));
            }
            if (b1 == b2) {
                return true;
            }
            if (b1.getClass() != b2.getClass()) {
                return false;
            }
            return b1.getKey().getName().equals(b2.getKey().getName()) && b1.getValue().equals(b2.getValue());
        }
    }
}

