/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    private static final Logger LOG = Logger.getInstance(GitRepositoryManager.class);
    public static final Comparator<GitRepository> DEPENDENCY_COMPARATOR = (repo1, repo2) -> -VirtualFileHierarchicalComparator.getInstance().compare(repo1.getRoot(), repo2.getRoot());
    @NotNull
    private final GitVcsSettings mySettings;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    @Deprecated
    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        this(project, vcsRepositoryManager);
    }

    public GitRepositoryManager(@NotNull Project project, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        super(vcsRepositoryManager, (AbstractVcs)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))), ".git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    @NotNull
    public static GitRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "getInstance"));
        }
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        if (gitRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "getInstance"));
        }
        return gitRepositoryManager;
    }

    public boolean isSyncEnabled() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new GitMultiRootBranchConfig(this.getRepositories()).diverged();
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list = this.getRepositories(GitRepository.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "getRepositories"));
        }
        return list;
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }

    @NotNull
    public Collection<GitRepository> getDirectSubmodules(@NotNull GitRepository superProject) {
        if (superProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superProject", "git4idea/repo/GitRepositoryManager", "getDirectSubmodules"));
        }
        Collection<GitSubmoduleInfo> modules = superProject.getSubmodules();
        List list = ContainerUtil.mapNotNull(modules, module -> {
            if (superProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superProject", "git4idea/repo/GitRepositoryManager", "lambda$getDirectSubmodules$1"));
            }
            VirtualFile submoduleDir = superProject.getRoot().findFileByRelativePath(module.getPath());
            if (submoduleDir == null) {
                LOG.debug("submodule dir not found at declared path [" + module.getPath() + "] of root [" + superProject.getRoot() + "]");
                return null;
            }
            GitRepository repository = (GitRepository)this.getRepositoryForRoot(submoduleDir);
            if (repository == null) {
                LOG.warn("Submodule not registered as a repository: " + submoduleDir);
            }
            return repository;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "getDirectSubmodules"));
        }
        return list;
    }

    @NotNull
    public List<GitRepository> sortByDependency(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/repo/GitRepositoryManager", "sortByDependency"));
        }
        List list = ContainerUtil.sorted(repositories, DEPENDENCY_COMPARATOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "sortByDependency"));
        }
        return list;
    }
}

