/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.util.Consumer;
import git4idea.GitCommit;
import git4idea.ui.GitCommitListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitCommitListWithDiffPanel
extends JPanel {
    private final ChangesBrowser myChangesBrowser;
    private final GitCommitListPanel myCommitListPanel;

    public GitCommitListWithDiffPanel(@NotNull Project project, @NotNull List<GitCommit> commits2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/GitCommitListWithDiffPanel", "<init>"));
        }
        if (commits2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/ui/GitCommitListWithDiffPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myCommitListPanel = new GitCommitListPanel(commits2, null);
        this.myCommitListPanel.addListMultipleSelectionListener(new Consumer<List<Change>>(){

            public void consume(List<Change> changes) {
                GitCommitListWithDiffPanel.this.myChangesBrowser.setChangesToDisplay(changes);
            }
        });
        this.myChangesBrowser = new ChangesBrowser(project, null, Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myCommitListPanel.registerDiffAction(this.myChangesBrowser.getDiffAction());
        Splitter splitter = new Splitter(false, 0.7f);
        splitter.setHonorComponentsMinimumSize(false);
        splitter.setFirstComponent((JComponent)this.myCommitListPanel);
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.add((Component)splitter);
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        JComponent jComponent = this.myCommitListPanel.getPreferredFocusComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/GitCommitListWithDiffPanel", "getPreferredFocusComponent"));
        }
        return jComponent;
    }

    public void setCommits(@NotNull List<GitCommit> commits2) {
        if (commits2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/ui/GitCommitListWithDiffPanel", "setCommits"));
        }
        this.myCommitListPanel.setCommits(commits2);
    }
}

