/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.update.GitFetcher;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final List<GitRepository> myRepositories;
    private final boolean myCheckRebaseOverMergeProblem;
    private final boolean myCheckForTrackedBranchExistance;
    private final UpdatedFiles myUpdatedFiles;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final GitMerger myMerger;

    public GitUpdateProcess(@NotNull Project project, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories, @NotNull UpdatedFiles updatedFiles, boolean checkRebaseOverMergeProblem, boolean checkForTrackedBranchExistance) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        this.myProject = project;
        this.myCheckRebaseOverMergeProblem = checkRebaseOverMergeProblem;
        this.myCheckForTrackedBranchExistance = checkForTrackedBranchExistance;
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myUpdatedFiles = updatedFiles;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitUpdateResult update(UpdateMethod updateMethod) {
        GitUpdateResult result2;
        LOG.info("update started|" + (Object)((Object)updateMethod));
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Updating...");
        for (GitRepository repository : this.myRepositories) {
            repository.update();
        }
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
            }
            return gitUpdateResult;
        }
        if (this.checkTrackedBranchesConfiguration() == null) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
            }
            return gitUpdateResult;
        }
        if (!this.fetchAndNotify()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
            }
            return gitUpdateResult;
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            result2 = this.updateImpl(updateMethod);
        }
        finally {
            token.finish();
        }
        this.myProgressIndicator.setText(oldText);
        GitUpdateResult gitUpdateResult = result2;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
        }
        return gitUpdateResult;
    }

    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod) {
        Collection<GitRepository> problematicRoots;
        Map<GitRepository, GitUpdater> updaters;
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/update/GitUpdateProcess", "updateImpl"));
        }
        Map<VirtualFile, GitBranchPair> trackedBranches = this.checkTrackedBranchesConfiguration();
        if (trackedBranches == null) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        try {
            updaters = this.defineUpdaters(updateMethod, trackedBranches);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", e.getMessage(), true, (Exception)((Object)e));
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        if (updaters.isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOTHING_TO_UPDATE;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        if ((updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters)).isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.SUCCESS;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        if (this.myCheckRebaseOverMergeProblem && !(problematicRoots = this.findRootsRebasingOverMerge(updaters)).isEmpty()) {
            Object decision = GitRebaseOverMergeProblem.showDialog();
            if (decision == GitRebaseOverMergeProblem.Decision.MERGE_INSTEAD) {
                for (GitRepository repo : problematicRoots) {
                    VirtualFile root = repo.getRoot();
                    GitBranchPair branchAndTracked = trackedBranches.get(root);
                    if (branchAndTracked == null) {
                        LOG.error("No tracked branch information for root " + root);
                        continue;
                    }
                    updaters.put(repo, new GitMergeUpdater(this.myProject, this.myGit, root, branchAndTracked, this.myProgressIndicator, this.myUpdatedFiles));
                }
            } else if (decision == GitRebaseOverMergeProblem.Decision.CANCEL_OPERATION) {
                GitUpdateResult gitUpdateResult = GitUpdateResult.CANCEL;
                if (gitUpdateResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
                }
                return gitUpdateResult;
            }
        }
        ArrayList myRootsToSave = ContainerUtil.newArrayList();
        LOG.info("updateImpl: identifying if save is needed...");
        for (Map.Entry entry : updaters.entrySet()) {
            GitRepository repo;
            repo = (GitRepository)entry.getKey();
            GitUpdater updater = (GitUpdater)entry.getValue();
            if (!updater.isSaveNeeded()) continue;
            myRootsToSave.add(repo.getRoot());
            LOG.info("update| root " + repo + " needs save");
        }
        LOG.info("updateImpl: saving local changes...");
        Ref incomplete = Ref.create((Object)false);
        Ref ref = Ref.create();
        Map<GitRepository, GitUpdater> finalUpdaters = updaters;
        new GitPreservingProcess(this.myProject, this.myGit, myRootsToSave, "Update", "Remote", GitVcsSettings.getInstance(this.myProject).updateChangesPolicy(), this.myProgressIndicator, () -> {
            LOG.info("updateImpl: updating...");
            GitRepository currentlyUpdatedRoot = null;
            try {
                for (GitRepository repo : this.myRepositories) {
                    GitUpdater updater = (GitUpdater)finalUpdaters.get(repo);
                    if (updater == null) continue;
                    currentlyUpdatedRoot = repo;
                    GitUpdateResult res = updater.update();
                    LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + (Object)((Object)res));
                    if (res == GitUpdateResult.INCOMPLETE) {
                        incomplete.set((Object)true);
                    }
                    compoundResult.set((Object)GitUpdateProcess.joinResults((GitUpdateResult)((Object)((Object)((Object)compoundResult.get()))), res));
                }
            }
            catch (VcsException e) {
                String rootName = currentlyUpdatedRoot == null ? "" : DvcsUtil.getShortRepositoryName(currentlyUpdatedRoot);
                LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
                GitUIUtil.notifyImportantError(this.myProject, "Error updating " + rootName, "Updating " + rootName + " failed with an error: " + e.getLocalizedMessage());
            }
        }).execute((Computable<Boolean>)((Computable)() -> (Boolean)incomplete.get() == false && !compoundResult.isNull() && ((GitUpdateResult)((Object)((Object)((Object)compoundResult.get())))).isSuccess()));
        GitUpdateResult gitUpdateResult = (GitUpdateResult)((Object)ObjectUtils.notNull((Object)ref.get(), (Object)((Object)GitUpdateResult.ERROR)));
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
        }
        return gitUpdateResult;
    }

    @NotNull
    private Collection<GitRepository> findRootsRebasingOverMerge(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "git4idea/update/GitUpdateProcess", "findRootsRebasingOverMerge"));
        }
        List list = ContainerUtil.mapNotNull(updaters.keySet(), repo -> {
            if (updaters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "git4idea/update/GitUpdateProcess", "lambda$findRootsRebasingOverMerge$2"));
            }
            GitUpdater updater = (GitUpdater)updaters.get(repo);
            if (updater instanceof GitRebaseUpdater) {
                String currentRef = updater.getSourceAndTarget().getBranch().getFullName();
                String baseRef = ((GitRemoteBranch)ObjectUtils.assertNotNull((Object)updater.getSourceAndTarget().getDest())).getFullName();
                return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo : null;
            }
            return null;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "findRootsRebasingOverMerge"));
        }
        return list;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "git4idea/update/GitUpdateProcess", "tryFastForwardMergeForRebaseUpdaters"));
        }
        HashMap<GitRepository, GitUpdater> modifiedUpdaters = new HashMap<GitRepository, GitUpdater>();
        Map changesUnderRoots = new LocalChangesUnderRoots(this.myChangeListManager, this.myVcsManager).getChangesUnderRoots(GitUtil.getRootsFromRepositories(updaters.keySet()));
        for (GitRepository repository : this.myRepositories) {
            GitRebaseUpdater rebaseUpdater;
            GitUpdater updater = updaters.get(repository);
            if (updater == null) continue;
            Collection changes = (Collection)changesUnderRoots.get(repository.getRoot());
            LOG.debug("Changes under root '" + DvcsUtil.getShortRepositoryName((Repository)repository) + "': " + changes);
            if (updater instanceof GitRebaseUpdater && changes != null && !changes.isEmpty() && (rebaseUpdater = (GitRebaseUpdater)updater).fastForwardMerge()) continue;
            modifiedUpdaters.put(repository, updater);
        }
        HashMap<GitRepository, GitUpdater> hashMap = modifiedUpdaters;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "tryFastForwardMergeForRebaseUpdaters"));
        }
        return hashMap;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches) throws VcsException {
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/update/GitUpdateProcess", "defineUpdaters"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranches", "git4idea/update/GitUpdateProcess", "defineUpdaters"));
        }
        HashMap<GitRepository, GitUpdater> updaters = new HashMap<GitRepository, GitUpdater>();
        LOG.info("updateImpl: defining updaters...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitBranchPair branchAndTracked = trackedBranches.get(root);
            if (branchAndTracked == null) continue;
            GitUpdater updater = GitUpdater.getUpdater(this.myProject, this.myGit, branchAndTracked, root, this.myProgressIndicator, this.myUpdatedFiles, updateMethod);
            if (updater.isUpdateNeeded()) {
                updaters.put(repository, updater);
            }
            LOG.info("update| root=" + root + " ,updater=" + updater);
        }
        HashMap<GitRepository, GitUpdater> hashMap = updaters;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "defineUpdaters"));
        }
        return hashMap;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result2) {
        if (compoundResult == null) {
            GitUpdateResult gitUpdateResult = result2;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "joinResults"));
            }
            return gitUpdateResult;
        }
        GitUpdateResult gitUpdateResult = compoundResult.join(result2);
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "joinResults"));
        }
        return gitUpdateResult;
    }

    private boolean fetchAndNotify() {
        return new GitFetcher(this.myProject, this.myProgressIndicator, false).fetchRootsAndNotify(this.myRepositories, "Update failed", false);
    }

    @Nullable
    private Map<VirtualFile, GitBranchPair> checkTrackedBranchesConfiguration() {
        HashMap trackedBranches = ContainerUtil.newHashMap();
        LOG.info("checking tracked branch configuration...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch == null) {
                LOG.info("checkTrackedBranchesConfigured: current branch is null in " + repository);
                GitUIUtil.notifyImportantError(this.myProject, "Can't update: no current branch", "You are in 'detached HEAD' state, which means that you're not on any branch" + GitUtil.mention(repository) + "<br/>Checkout a branch to make update possible.");
                return null;
            }
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch);
            if (trackInfo == null) {
                LOG.info(String.format("checkTrackedBranchesConfigured: no track info for current branch %s in %s", branch, repository));
                if (!this.myCheckForTrackedBranchExistance) continue;
                GitUIUtil.notifyImportantError(repository.getProject(), "Can't Update", GitUpdateProcess.getNoTrackedBranchError(repository, branch.getName()));
                return null;
            }
            trackedBranches.put(root, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
        }
        return trackedBranches;
    }

    @VisibleForTesting
    @NotNull
    static String getNoTrackedBranchError(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitUpdateProcess", "getNoTrackedBranchError"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/update/GitUpdateProcess", "getNoTrackedBranchError"));
        }
        String recommendedCommand = GitUpdateProcess.recommendSetupTrackingCommand(repository, branchName);
        String string = "No tracked branch configured for branch " + GitUIUtil.code(branchName) + GitUtil.mention(repository) + " or the branch doesn't exist.<br/>To make your branch track a remote branch call, for example,<br/><code>" + recommendedCommand + "</code>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "getNoTrackedBranchError"));
        }
        return string;
    }

    @NotNull
    private static String recommendSetupTrackingCommand(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/update/GitUpdateProcess", "recommendSetupTrackingCommand"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/update/GitUpdateProcess", "recommendSetupTrackingCommand"));
        }
        String string = String.format(GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository.getVcs().getVersion()) ? "git branch --set-upstream-to origin/%1$s %1$s" : "git branch --set-upstream %1$s origin/%1$s", branchName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "recommendSetupTrackingCommand"));
        }
        return string;
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished merge. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Update was not started");
        params.setMergeDescription("Unmerged files detected. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator);
        final Collection<VirtualFile> rebasingRoots = rebaser.getRebasingRoots();
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished rebase process. These conflicts must be resolved before update.");
        params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, this.myGit, rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return rebaser.continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return rebaser.continueRebase(rebasingRoots);
            }
        }.merge();
    }
}

