/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.codeInsight.ChangeAnnotationFix;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspection;
import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.junit.JUnitCommonClassNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedParameterizedInspection;", "Lcom/intellij/codeInspection/BaseJavaBatchLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "hasMultipleParameters", "method", "Lcom/intellij/psi/PsiMethod;", "junit"})
public final class JUnit5MalformedParameterizedInspection
extends BaseJavaBatchLocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message((String)"junit5.valid.parameterized.configuration.display.name", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"InspectionGadgetsBundle.\u2026figuration.display.name\")");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiFile file = holder.getFile();
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        if (JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.junit.jupiter.params.ParameterizedTest", file.getResolveScope()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JavaElementVisitor(this, holder){
            final /* synthetic */ JUnit5MalformedParameterizedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitMethod(@NotNull PsiMethod method) {
                block20: {
                    Object[] objectArray;
                    Object[] objectArray2;
                    PsiAnnotation[] testAnnotation;
                    block16: {
                        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                        PsiAnnotation[] parameterizedAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Collections.singletonList("org.junit.jupiter.params.ParameterizedTest"));
                        testAnnotation = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_JUPITER_ANNOTATIONS);
                        objectArray = objectArray2 = (Object[])parameterizedAnnotation;
                        if (!(!(objectArray.length == 0))) break block16;
                        objectArray2 = testAnnotation;
                        objectArray = objectArray2;
                        if (!(objectArray.length == 0) && method.getParameterList().getParametersCount() > 0) {
                            this.$holder.registerProblem((PsiElement)testAnnotation[0], "Suspicious combination @Test and @ParameterizedTest", new LocalQuickFix[]{(LocalQuickFix)new DeleteElementFix((PsiElement)testAnnotation[0])});
                        }
                        boolean noMultiArgsProvider = true;
                        PsiAnnotation source = null;
                        Object[] $receiver$iv = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS);
                        block8: for (int i = 0; i < $receiver$iv.length; ++i) {
                            block17: {
                                PsiAnnotation it;
                                block18: {
                                    block19: {
                                        String string;
                                        Object element$iv = $receiver$iv[i];
                                        it = (PsiAnnotation)element$iv;
                                        String string2 = string = it.getQualifiedName();
                                        if (string2 == null) continue;
                                        switch (string2.hashCode()) {
                                            case -2084799780: {
                                                if (!string.equals("org.junit.jupiter.params.provider.ValueSource")) continue block8;
                                                break;
                                            }
                                            case 124822449: {
                                                if (!string.equals("org.junit.jupiter.params.provider.CsvSource")) continue block8;
                                                break block17;
                                            }
                                            case 2141896013: {
                                                if (!string.equals("org.junit.jupiter.params.provider.CsvFileSource")) continue block8;
                                                break block18;
                                            }
                                            case -1320765300: {
                                                if (!string.equals("org.junit.jupiter.params.provider.EnumSource")) continue block8;
                                                break block19;
                                            }
                                            case -205673727: {
                                                if (!string.equals("org.junit.jupiter.params.provider.ArgumentsSource")) continue block8;
                                                break block17;
                                            }
                                            case 2129905772: {
                                                if (!string.equals("org.junit.jupiter.params.provider.MethodSource")) continue block8;
                                                PsiAnnotation psiAnnotation = it;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                                                this.checkMethodSource(method, psiAnnotation);
                                                noMultiArgsProvider = false;
                                                continue block8;
                                            }
                                        }
                                        PsiAnnotation psiAnnotation = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                                        this.checkValuesSource(method, psiAnnotation);
                                        source = it;
                                        continue;
                                    }
                                    PsiAnnotation psiAnnotation = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                                    this.checkEnumSource(method, psiAnnotation);
                                    source = it;
                                    continue;
                                }
                                PsiAnnotation psiAnnotation = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                                this.checkFileSource(psiAnnotation);
                                noMultiArgsProvider = false;
                                continue;
                            }
                            noMultiArgsProvider = false;
                        }
                        if (noMultiArgsProvider) {
                            if (source == null) {
                                this.$holder.registerProblem((PsiElement)parameterizedAnnotation[0], "No sources are provided, the suite would be empty", new LocalQuickFix[0]);
                            } else if (JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0, method)) {
                                PsiAnnotation psiAnnotation = source;
                                if (psiAnnotation == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.$holder.registerProblem((PsiElement)psiAnnotation, "Multiple parameters are not supported by this source", new LocalQuickFix[0]);
                            }
                        }
                        objectArray = null;
                        Object var4_6 = null;
                        break block20;
                    }
                    objectArray2 = testAnnotation;
                    objectArray = objectArray2;
                    if (!(objectArray.length == 0) && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitCommonClassNames.SOURCE_ANNOTATIONS)) {
                        PsiElement psiElement = (PsiElement)testAnnotation[0];
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                        PsiAnnotation psiAnnotation = testAnnotation[0];
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"testAnnotation[0]");
                        localQuickFixArray[0] = (LocalQuickFix)new ChangeAnnotationFix(psiAnnotation, "org.junit.jupiter.params.ParameterizedTest");
                        this.$holder.registerProblem(psiElement, "Suspicious combination @Test and parameterized source", localQuickFixArray);
                    }
                }
            }

            private final void checkEnumSource(PsiMethod method, PsiAnnotation enumSource) {
                this.processArrayInAnnotationParameter(enumSource.findAttributeValue("value"), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ PsiMethod $method;

                    public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                        if (value instanceof PsiClassObjectAccessExpression) {
                            PsiType psiType = ((PsiClassObjectAccessExpression)value).getOperand().getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"value.operand.type");
                            buildVisitor.1.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, psiType);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$method = psiMethod;
                        super(1);
                    }
                }));
            }

            private final void checkValuesSource(PsiMethod method, PsiAnnotation valuesSource) {
                Map possibleValues = ContainerUtil.immutableMapBuilder().put((Object)"strings", (Object)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope())).put((Object)"ints", (Object)PsiType.INT).put((Object)"longs", (Object)PsiType.LONG).put((Object)"doubles", (Object)PsiType.DOUBLE).build();
                for (String valueKey : possibleValues.keySet()) {
                    this.processArrayInAnnotationParameter(valuesSource.findDeclaredAttributeValue(valueKey), (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method, possibleValues, valueKey){
                        final /* synthetic */ buildVisitor.1 this$0;
                        final /* synthetic */ PsiMethod $method;
                        final /* synthetic */ Map $possibleValues;
                        final /* synthetic */ String $valueKey;

                        public final void invoke(@NotNull PsiAnnotationMemberValue value) {
                            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                            V v = this.$possibleValues.get(this.$valueKey);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            buildVisitor.1.access$checkSourceTypeAndParameterTypeAgree(this.this$0, this.$method, value, (PsiType)v);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$method = psiMethod;
                            this.$possibleValues = map;
                            this.$valueKey = string;
                            super(1);
                        }
                    }));
                }
                int attributesNumber = ((Object[])valuesSource.getParameterList().getAttributes()).length;
                if (attributesNumber > 1) {
                    this.$holder.registerProblem((PsiElement)valuesSource, "Exactly one type of input must be provided", new LocalQuickFix[0]);
                } else if (attributesNumber == 0) {
                    this.$holder.registerProblem((PsiElement)valuesSource, "No value source is defined", new LocalQuickFix[0]);
                }
            }

            private final void checkFileSource(PsiAnnotation methodSource) {
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("resources");
                this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                        Object v0;
                        List refs;
                        block7: {
                            Object $receiver$iv$iv;
                            Intrinsics.checkParameterIsNotNull((Object)attributeValue, (String)"attributeValue");
                            Object $receiver$iv = attributeValue.getReferences();
                            Object[] objectArray = $receiver$iv;
                            Object destination$iv$iv = new ArrayList<E>();
                            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                                void element$iv$iv = $receiver$iv$iv[i];
                                PsiReference it = (PsiReference)element$iv$iv;
                                if (!(it instanceof FileReference)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            refs = (List)destination$iv$iv;
                            $receiver$iv$iv = $receiver$iv = (Iterable)refs;
                            destination$iv$iv = $receiver$iv$iv.iterator();
                            while (destination$iv$iv.hasNext()) {
                                E e = destination$iv$iv.next();
                                PsiReference reference = (PsiReference)e;
                                if (!(reference.resolve() != null)) continue;
                                v0 = e;
                                break block7;
                            }
                            v0 = null;
                        }
                        if (v0 == null) {
                            LocalQuickFix[] localQuickFixArray;
                            PsiReference reference = (PsiReference)CollectionsKt.first((List)refs);
                            if (reference != null) {
                                Collection $receiver$iv;
                                Collection collection = $receiver$iv = (Collection)FileReferenceQuickFixProvider.registerQuickFix((FileReference)((FileReference)reference));
                                if (collection == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                                }
                                Collection thisCollection$iv = collection;
                                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[thisCollection$iv.size()]);
                                if (localQuickFixArray2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                localQuickFixArray = localQuickFixArray2;
                            } else {
                                localQuickFixArray = new LocalQuickFix[]{};
                            }
                            LocalQuickFix[] fixes = localQuickFixArray;
                            this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Cannot resolve file source: '" + attributeValue.getText() + "'", Arrays.copyOf(fixes, fixes.length));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }

            private final void checkMethodSource(PsiMethod method, PsiAnnotation methodSource) {
                PsiAnnotationMemberValue annotationMemberValue = methodSource.findDeclaredAttributeValue("value");
                this.processArrayInAnnotationParameter(annotationMemberValue, (Function1<? super PsiAnnotationMemberValue, Unit>)((Function1)new Function1<PsiAnnotationMemberValue, Unit>(this, method){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ PsiMethod $method;

                    public final void invoke(@NotNull PsiAnnotationMemberValue attributeValue) {
                        Intrinsics.checkParameterIsNotNull((Object)attributeValue, (String)"attributeValue");
                        PsiReference[] psiReferenceArray = attributeValue.getReferences();
                        for (int i = 0; i < psiReferenceArray.length; ++i) {
                            PsiReference reference = psiReferenceArray[i];
                            if (!(reference instanceof MethodSourceReference)) continue;
                            PsiElement resolve = reference.resolve();
                            if (!(resolve instanceof PsiMethod)) {
                                PsiClass containingClass = this.$method.getContainingClass();
                                CreateMethodQuickFix createFix = null;
                                if (containingClass != null && this.this$0.$holder.isOnTheFly()) {
                                    createFix = CreateMethodQuickFix.createFix((PsiClass)containingClass, (String)("static Object[][] " + ((MethodSourceReference)reference).getValue() + "()"), (String)"return new Object[][] {};");
                                }
                                this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Cannot resolve target method source: '" + ((MethodSourceReference)reference).getValue() + "'", new LocalQuickFix[]{(LocalQuickFix)createFix});
                                continue;
                            }
                            PsiMethod sourceProvider = (PsiMethod)resolve;
                            String providerName = sourceProvider.getName();
                            if (!sourceProvider.hasModifierProperty("static")) {
                                this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Method source " + "'" + providerName + "'" + " must be static", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)sourceProvider, "static", true, false)});
                                continue;
                            }
                            if (sourceProvider.getParameterList().getParametersCount() != 0) {
                                this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Method source " + "'" + providerName + "'" + " should have no parameters", new LocalQuickFix[0]);
                                continue;
                            }
                            PsiType componentType = buildVisitor.1.access$getComponentType(this.this$0, sourceProvider.getReturnType(), this.$method);
                            if (componentType == null) {
                                this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Method source " + "'" + providerName + "'" + " must have one of the following return type: Stream<?>, Iterator<?>, Iterable<?> or Object[]", new LocalQuickFix[0]);
                                continue;
                            }
                            if (!JUnit5MalformedParameterizedInspection.access$hasMultipleParameters(this.this$0.this$0, this.$method) || buildVisitor.1.access$isArgumentsInheritor(this.this$0, componentType) || componentType.equalsToText("java.lang.Object")) continue;
                            this.this$0.$holder.registerProblem((PsiElement)attributeValue, "Multiple parameters have to be wrapped in Arguments", new LocalQuickFix[0]);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$method = psiMethod;
                        super(1);
                    }
                }));
            }

            private final void processArrayInAnnotationParameter(PsiAnnotationMemberValue attributeValue, Function1<? super PsiAnnotationMemberValue, Unit> checker) {
                if (attributeValue instanceof PsiLiteral || attributeValue instanceof PsiClassObjectAccessExpression) {
                    checker.invoke((Object)attributeValue);
                } else if (attributeValue instanceof PsiArrayInitializerMemberValue) {
                    PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = ((PsiArrayInitializerMemberValue)attributeValue).getInitializers();
                    for (int i = 0; i < psiAnnotationMemberValueArray.length; ++i) {
                        PsiAnnotationMemberValue memberValue = psiAnnotationMemberValueArray[i];
                        this.processArrayInAnnotationParameter(memberValue, checker);
                    }
                }
            }

            private final void checkSourceTypeAndParameterTypeAgree(PsiMethod method, PsiAnnotationMemberValue attributeValue, PsiType componentType) {
                PsiType paramType;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (((Object[])parameters).length == 1 && !(paramType = parameters[0].getType()).isAssignableFrom(componentType) && !this.isArgumentsInheritor(componentType)) {
                    if (componentType.equalsToText("java.lang.String")) {
                        if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)paramType)) {
                            return;
                        }
                        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType);
                        if (psiClass != null) {
                            String qualifiedName;
                            if (psiClass.isEnum()) {
                                PsiAnnotationMemberValue psiAnnotationMemberValue = attributeValue;
                                if (psiAnnotationMemberValue == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiLiteral");
                                }
                                if (psiClass.findFieldByName((String)((PsiLiteral)psiAnnotationMemberValue).getValue(), false) != null) {
                                    return;
                                }
                            }
                            if ((qualifiedName = psiClass.getQualifiedName()) != null && StringsKt.startsWith$default((String)qualifiedName, (String)"java.time.", (boolean)false, (int)2, null)) {
                                return;
                            }
                        }
                    }
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)parameters[0]), (String)"org.junit.jupiter.params.converter.ConvertWith", (boolean)false)) {
                        return;
                    }
                    this.$holder.registerProblem((PsiElement)attributeValue, "No implicit conversion found to convert object of type " + componentType.getPresentableText() + " to " + paramType.getPresentableText(), new LocalQuickFix[0]);
                }
            }

            private final boolean isArgumentsInheritor(PsiType componentType) {
                return InheritanceUtil.isInheritor((PsiType)componentType, (String)"org.junit.jupiter.params.provider.Arguments");
            }

            private final PsiType getComponentType(PsiType returnType, PsiMethod method) {
                PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)returnType, (GlobalSearchScope)method.getResolveScope());
                if (collectionItemType != null) {
                    return collectionItemType;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.IntStream")) {
                    return (PsiType)PsiType.INT;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.LongStream")) {
                    return (PsiType)PsiType.LONG;
                }
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.DoubleStream")) {
                    return (PsiType)PsiType.DOUBLE;
                }
                PsiType streamItemType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.stream.Stream", (int)0, (boolean)false);
                if (streamItemType != null) {
                    return streamItemType;
                }
                return PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Iterator", (int)0, (boolean)false);
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }

            public static final /* synthetic */ void access$checkSourceTypeAndParameterTypeAgree(buildVisitor.1 $this, @NotNull PsiMethod method, @NotNull PsiAnnotationMemberValue attributeValue, @NotNull PsiType componentType) {
                $this.checkSourceTypeAndParameterTypeAgree(method, attributeValue, componentType);
            }

            @Nullable
            public static final /* synthetic */ PsiType access$getComponentType(buildVisitor.1 $this, @Nullable PsiType returnType, @NotNull PsiMethod method) {
                return $this.getComponentType(returnType, method);
            }

            public static final /* synthetic */ boolean access$isArgumentsInheritor(buildVisitor.1 $this, @NotNull PsiType componentType) {
                return $this.isArgumentsInheritor(componentType);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasMultipleParameters(PsiMethod method) {
        void $receiver$iv$iv;
        Object[] $receiver$iv = method.getParameterList().getParameters();
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            PsiParameter it = (PsiParameter)element$iv$iv;
            if (!(!InheritanceUtil.isInheritor((PsiType)it.getType(), (String)"org.junit.jupiter.api.TestInfo") && !InheritanceUtil.isInheritor((PsiType)it.getType(), (String)"org.junit.jupiter.api.TestReporter"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        return collection.size() > 1 && !AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Collections.singleton("org.junit.jupiter.api.extension.ExtendWith"));
    }

    public static final /* synthetic */ boolean access$hasMultipleParameters(JUnit5MalformedParameterizedInspection $this, @NotNull PsiMethod method) {
        return $this.hasMultipleParameters(method);
    }
}

