/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightVisitorInternalInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(HighlightVisitorInternalInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/HighlightVisitorInternalInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/HighlightVisitorInternalInspection", "buildVisitor"));
        }
        final PsiFile file = holder.getFile();
        if (InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/HighlightVisitorInternalInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null || virtualFile.getFileType() != StdFileTypes.JAVA || CompilerConfiguration.getInstance((Project)holder.getProject()).isExcludedFromCompilation(virtualFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/HighlightVisitorInternalInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        HighlightVisitorImpl highlightVisitorImpl = new HighlightVisitorImpl(JavaPsiFacade.getInstance((Project)holder.getProject()).getResolveHelper()){
            {
                super(arg0);
                this.prepareToRunAsInspection(new HighlightInfoHolder(file, new HighlightInfoFilter[0]){

                    public boolean add(@Nullable HighlightInfo info) {
                        if (super.add(info)) {
                            int startOffset;
                            PsiElement element;
                            if (info != null && info.getSeverity() == HighlightSeverity.ERROR && (element = file.findElementAt(startOffset = info.getStartOffset())) != null) {
                                holder.registerProblem(element, info.getDescription(), new LocalQuickFix[0]);
                            }
                            return true;
                        }
                        return false;
                    }

                    public boolean hasErrorResults() {
                        return false;
                    }
                });
            }
        };
        if (highlightVisitorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/HighlightVisitorInternalInspection", "buildVisitor"));
        }
        return highlightVisitorImpl;
    }
}

