/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataHighlightingPass;

public class TestDataHighlightingPassFactory
implements ProjectComponent,
TextEditorHighlightingPassFactory {
    public static final List<String> SUPPORTED_FILE_TYPES = Arrays.asList(StdFileTypes.JAVA.getDefaultExtension());
    public static final List<String> SUPPORTED_IN_TEST_DATA_FILE_TYPES = Arrays.asList("js", "php", "css", "html", "xhtml", "jsp", "test", "py", "aj");
    private static final int MAX_HOPES = 3;
    private static final String TEST_DATA = "testdata";
    private final Project myProject;

    public TestDataHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPassFactory", "createHighlightingPass"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && this.isSupported(virtualFile)) {
            return new TestDataHighlightingPass(this.myProject, PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file));
        }
        return null;
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPassFactory", "isSupported"));
        }
        String ext = file.getExtension();
        if (SUPPORTED_FILE_TYPES.contains(ext)) {
            return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(file) == null;
        }
        if (SUPPORTED_IN_TEST_DATA_FILE_TYPES.contains(ext)) {
            int i = 0;
            for (VirtualFile parent = file.getParent(); parent != null && i < 3; ++i, parent = parent.getParent()) {
                if (!parent.getName().toLowerCase().contains(TEST_DATA)) continue;
                return true;
            }
        }
        return false;
    }
}

