/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.testFramework.PlatformTestUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.evaluation.SimpleEvaluatorExtension;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.values.UBooleanConstant;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class TestDataReferenceCollector {
    private static final String TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME = "com.intellij.testFramework.TestDataFile";
    private final String myTestDataPath;
    private final String myTestName;
    private final List<String> myLogMessages = new ArrayList<String>();
    private PsiClass myContainingClass;
    private boolean myFoundTestDataParameters = false;

    public TestDataReferenceCollector(@Nullable String testDataPath, String testName) {
        if (StringUtil.isNotEmpty((String)testDataPath) && !StringUtil.endsWithChar((CharSequence)testDataPath, (char)File.separatorChar)) {
            testDataPath = testDataPath + File.separatorChar;
        }
        this.myTestDataPath = testDataPath;
        this.myTestName = testName;
    }

    @Nullable
    List<String> collectTestDataReferences(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector", "collectTestDataReferences"));
        }
        this.myContainingClass = method.getContainingClass();
        List<String> result = this.collectTestDataReferences(method, new HashMap<String, Computable<UValue>>(), new HashSet<PsiMethod>());
        if (!this.myFoundTestDataParameters) {
            this.myLogMessages.add("Found no parameters annotated with @TestDataFile");
        }
        if (result.isEmpty()) {
            result = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method);
        }
        return result;
    }

    @NotNull
    private List<String> collectTestDataReferences(PsiMethod method, final Map<String, Computable<UValue>> argumentMap, final HashSet<PsiMethod> proceed) {
        final ArrayList<String> result = new ArrayList<String>();
        if (this.myTestDataPath == null) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector", "collectTestDataReferences"));
            }
            return arrayList;
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method);
        if (uMethod == null) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector", "collectTestDataReferences"));
            }
            return arrayList;
        }
        uMethod.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitCallExpression(UCallExpression expression) {
                UMethod implementation;
                PsiClass calleeContainingClass;
                String callText = expression.getMethodName();
                if (callText == null) {
                    return true;
                }
                UMethod callee = (UMethod)UastContextKt.toUElement((PsiElement)expression.resolve(), UMethod.class);
                if (callee != null && callee.hasModifierProperty("abstract") && (calleeContainingClass = callee.getContainingClass()) != null && TestDataReferenceCollector.this.myContainingClass.isInheritor(calleeContainingClass, true) && (implementation = (UMethod)UastContextKt.toUElement((PsiElement)TestDataReferenceCollector.this.myContainingClass.findMethodBySignature((PsiMethod)callee, true), UMethod.class)) != null) {
                    callee = implementation;
                }
                if (callee != null && proceed.add(callee)) {
                    boolean haveAnnotatedParameters = false;
                    PsiParameter[] psiParameters = callee.getParameterList().getParameters();
                    int psiParametersLength = psiParameters.length;
                    for (int i = 0; i < psiParametersLength; ++i) {
                        PsiParameter psiParameter = psiParameters[i];
                        PsiModifierList modifierList = psiParameter.getModifierList();
                        if (modifierList == null || modifierList.findAnnotation(TestDataReferenceCollector.TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME) == null) continue;
                        TestDataReferenceCollector.this.myFoundTestDataParameters = true;
                        TestDataReferenceCollector.this.processCallArgument(expression, argumentMap, result, i);
                        haveAnnotatedParameters = true;
                    }
                    if (expression.getReceiver() == null && !haveAnnotatedParameters) {
                        result.addAll(TestDataReferenceCollector.this.collectTestDataReferences((PsiMethod)callee, TestDataReferenceCollector.this.buildArgumentMap(expression, (PsiMethod)callee), proceed));
                    }
                }
                return true;
            }
        });
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector", "collectTestDataReferences"));
        }
        return arrayList;
    }

    private void processCallArgument(UCallExpression expression, Map<String, Computable<UValue>> argumentMap, List<String> result, int index) {
        UValue testDataFileValue;
        List arguments = expression.getValueArguments();
        if (arguments.size() > index && (testDataFileValue = UEvaluationContextKt.uValueOf((UExpression)((UExpression)arguments.get(index)), (UEvaluatorExtension[])new UEvaluatorExtension[]{new TestDataEvaluatorExtension(argumentMap)})) instanceof UStringConstant) {
            result.add(this.myTestDataPath + ((UStringConstant)testDataFileValue).getValue());
        }
    }

    private Map<String, Computable<UValue>> buildArgumentMap(UCallExpression expression, PsiMethod method) {
        HashMap<String, Computable<UValue>> result = new HashMap<String, Computable<UValue>>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        List arguments = expression.getValueArguments();
        for (int i = 0; i < arguments.size() && i < parameters.length; ++i) {
            int finalI = i;
            result.put(parameters[i].getName(), (Computable<UValue>)((NullableComputable)() -> UEvaluationContextKt.uValueOf((UExpression)((UExpression)arguments.get(finalI)), (UEvaluatorExtension[])new UEvaluatorExtension[]{new TestDataEvaluatorExtension(Collections.emptyMap())})));
        }
        return result;
    }

    public String getLog() {
        return StringUtil.join(this.myLogMessages, (String)"\n");
    }

    private class TestDataEvaluatorExtension
    extends SimpleEvaluatorExtension {
        private final Map<String, Computable<UValue>> myArguments;

        private TestDataEvaluatorExtension(Map<String, Computable<UValue>> arguments) {
            this.myArguments = arguments;
        }

        public Object evaluateMethodCall(PsiMethod target, List<? extends UValue> argumentValues) {
            if (target.getName().equals("getTestName") && argumentValues.size() == 1) {
                boolean lowercaseArgValue;
                UValue lowercaseArg = argumentValues.get(0);
                boolean bl = lowercaseArgValue = lowercaseArg instanceof UBooleanConstant && ((UBooleanConstant)lowercaseArg).getValue() != false;
                if (lowercaseArgValue && !StringUtil.isEmpty((String)TestDataReferenceCollector.this.myTestName)) {
                    return PlatformTestUtil.lowercaseFirstLetter((String)TestDataReferenceCollector.this.myTestName, (boolean)true);
                }
                return TestDataReferenceCollector.this.myTestName;
            }
            return super.evaluateMethodCall(target, argumentValues);
        }

        public Object evaluateVariable(UVariable variable) {
            Computable<UValue> value;
            if (variable instanceof UParameter && (value = this.myArguments.get(variable.getName())) != null) {
                UValue computedValue = (UValue)value.compute();
                UConstant constant = computedValue.toConstant();
                return constant != null ? constant.getValue() : super.evaluateVariable(variable);
            }
            return super.evaluateVariable(variable);
        }
    }
}

