/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;

public class AnimatedRange
extends Range
implements Animatable {
    private static final float DEFAULT_LERP_FRACTION = 0.95f;
    private static final float DEFAULT_LERP_THRESHOLD = 0.001f;
    private double myTargetMin;
    private double myTargetMax;
    private float myLerpFraction;
    private float myLerpThreshold;

    public AnimatedRange(double min, double max) {
        super(min, max);
        this.myTargetMin = min;
        this.myTargetMax = max;
        this.myLerpFraction = 0.95f;
        this.myLerpThreshold = 0.001f;
    }

    public AnimatedRange() {
        this(0.0, 0.0);
    }

    @Override
    public void setLerpFraction(float fraction) {
        this.myLerpFraction = fraction;
    }

    @Override
    public void setLerpThreshold(float threshold) {
        this.myLerpThreshold = threshold;
    }

    @Override
    public void setMin(double min) {
        this.myTargetMin = min;
    }

    @Override
    public void setMax(double max) {
        this.myTargetMax = max;
    }

    @Override
    public void animate(float frameLength) {
        if (this.myMin != this.myTargetMin) {
            this.myMin = Choreographer.lerp(this.myMin, this.myTargetMin, this.myLerpFraction, frameLength, this.myLerpThreshold);
        }
        if (this.myMax != this.myTargetMax) {
            this.myMax = Choreographer.lerp(this.myMax, this.myTargetMax, this.myLerpFraction, frameLength, this.myLerpThreshold);
        }
    }
}

