/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public final class RangeScrollbar
extends JBScrollBar
implements Animatable {
    public static final double DEFAULT_VIEW_LENGTH_US = TimeUnit.SECONDS.toMicros(15L);
    private static final float STREAMING_POSITION_THRESHOLD = 0.1f;
    @NotNull
    private ScrollingMode mScrollingMode;
    private boolean mStableScrolling;
    @NotNull
    private final Range mGlobalRange;
    @NotNull
    private final Range mRange;
    private double mCurrentViewLength;

    public RangeScrollbar(@NotNull Range globalRange, @NotNull Range range) {
        if (globalRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalRange", "com/android/tools/adtui/RangeScrollbar", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/adtui/RangeScrollbar", "<init>"));
        }
        super(0);
        this.mGlobalRange = globalRange;
        this.mRange = range;
        this.mScrollingMode = ScrollingMode.STREAMING;
        this.mCurrentViewLength = DEFAULT_VIEW_LENGTH_US;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RangeScrollbar.this.mScrollingMode = ScrollingMode.SCROLLING;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RangeScrollbar.this.mScrollingMode = RangeScrollbar.this.closeToMaxRange() ? ScrollingMode.STREAMING : ScrollingMode.VIEWING;
                if (RangeScrollbar.this.mScrollingMode == ScrollingMode.STREAMING) {
                    RangeScrollbar.this.mCurrentViewLength = RangeScrollbar.this.mRange.getLength();
                }
            }
        });
    }

    public void setStableScrolling(boolean fixedScrolling) {
        this.mStableScrolling = fixedScrolling;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
    }

    @Override
    public void reset() {
        this.mScrollingMode = ScrollingMode.STREAMING;
        this.mCurrentViewLength = DEFAULT_VIEW_LENGTH_US;
        double now = this.mGlobalRange.getMax();
        this.mGlobalRange.set(now, now + this.mCurrentViewLength);
        this.mRange.set(now, now);
    }

    @Override
    public void animate(float frameLength) {
        if (this.mScrollingMode == ScrollingMode.STREAMING) {
            double globalMax = this.mGlobalRange.getMax();
            this.mRange.set(globalMax - this.mCurrentViewLength, globalMax);
        }
        double globalLength = this.mGlobalRange.getLength();
        double currentLength = this.mRange.getLength();
        int scrollbarExtent = this.getWidth();
        int scrollbarRange = (int)(globalLength * (double)scrollbarExtent / currentLength);
        switch (this.mScrollingMode) {
            case STREAMING: {
                this.setValues(scrollbarRange - scrollbarExtent, scrollbarExtent, 0, scrollbarRange);
                break;
            }
            case VIEWING: {
                this.setValues((int)((double)scrollbarRange * (this.mRange.getMin() - this.mGlobalRange.getMin()) / globalLength), scrollbarExtent, 0, scrollbarRange);
                break;
            }
            case SCROLLING: {
                float adjustedValue;
                if (!this.mStableScrolling) {
                    this.setMaximum(scrollbarRange);
                }
                if (Float.isNaN(adjustedValue = (float)this.getValue() / (float)(this.getMaximum() - scrollbarExtent) * (float)(scrollbarRange - scrollbarExtent))) {
                    adjustedValue = 0.0f;
                }
                double newMin = globalLength * (double)adjustedValue / (double)scrollbarRange + this.mGlobalRange.getMin();
                this.mRange.set(newMin, newMin + currentLength);
            }
        }
    }

    private boolean closeToMaxRange() {
        BoundedRangeModel model = this.getModel();
        return (float)(model.getMaximum() - (model.getValue() + model.getExtent())) < 0.1f * (float)model.getExtent();
    }

    private static class RangeScrollBarUI
    extends ButtonlessScrollBarUI {
        private RangeScrollBarUI() {
        }

        protected boolean isMacOverlayScrollbar() {
            return false;
        }
    }

    private static enum ScrollingMode {
        STREAMING,
        VIEWING,
        SCROLLING;

    }
}

