/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredPanel<T>
extends JBLayeredPane
implements SideModel.Listener<T>,
Disposable {
    private final String myBenchName;
    private final PropertiesComponent myPropertiesComponent;
    private final JComponent myDefaultLayer;
    private final ThreeComponentsSplitter mySplitter;
    private final JPanel myContainer;
    private String myToolName;
    private Side mySide;

    public LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model) {
        if (benchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "benchName", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        if (defaultLayer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultLayer", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        this(benchName, defaultLayer, model, PropertiesComponent.getInstance());
    }

    public LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model, @NotNull PropertiesComponent propertiesComponent) {
        if (benchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "benchName", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        if (defaultLayer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultLayer", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        if (propertiesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/android/tools/adtui/workbench/LayeredPanel", "<init>"));
        }
        this.myBenchName = benchName;
        this.myPropertiesComponent = propertiesComponent;
        this.myDefaultLayer = defaultLayer;
        this.myContainer = new JPanel();
        this.myContainer.setOpaque(false);
        this.myContainer.addComponentListener(this.createWidthUpdater());
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setOpaque(false);
        this.mySplitter.setInnerComponent((JComponent)this.myContainer);
        this.mySplitter.setDividerWidth(JBUI.scale((int)0));
        this.mySide = Side.LEFT;
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.add(defaultLayer, DEFAULT_LAYER);
        this.add((Component)this.mySplitter, PALETTE_LAYER);
        model.addListener(this);
    }

    ThreeComponentsSplitter getSplitter() {
        return this.mySplitter;
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model, @NotNull SideModel.EventType unused) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/LayeredPanel", "modelChanged"));
        }
        if (unused == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unused", "com/android/tools/adtui/workbench/LayeredPanel", "modelChanged"));
        }
        model.getHiddenSliders().forEach(this::addHiddenTool);
        this.addVisibleTool(model.getVisibleAutoHideTool());
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTool(@Nullable AttachedToolWindow<T> tool) {
        if (tool == null) {
            this.mySplitter.setVisible(false);
            this.mySplitter.setFirstComponent(null);
            this.mySplitter.setLastComponent(null);
            this.myToolName = null;
        } else {
            JComponent component = tool.getComponent();
            component.setVisible(true);
            this.mySplitter.setVisible(true);
            this.myToolName = tool.getToolName();
            if (tool.isLeft()) {
                this.mySide = Side.LEFT;
                this.mySplitter.setFirstComponent(component);
                this.mySplitter.setFirstSize(this.getToolWidth(tool));
                this.mySplitter.setLastComponent(null);
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)1));
            } else {
                this.mySide = Side.RIGHT;
                this.mySplitter.setFirstComponent(null);
                this.mySplitter.setLastComponent(component);
                this.mySplitter.setLastSize(this.getToolWidth(tool));
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)4));
            }
        }
    }

    private void addHiddenTool(@NotNull AttachedToolWindow<T> tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/LayeredPanel", "addHiddenTool"));
        }
        JComponent component = tool.getComponent();
        component.setVisible(false);
        this.myContainer.add((Component)component, PALETTE_LAYER);
    }

    public void doLayout() {
        this.myDefaultLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.mySplitter.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public void dispose() {
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width;
                int n = width = LayeredPanel.this.mySide.isLeft() ? LayeredPanel.this.mySplitter.getFirstSize() : LayeredPanel.this.mySplitter.getLastSize();
                if (LayeredPanel.this.myToolName != null && width > 0) {
                    LayeredPanel.this.setToolWidth(width);
                }
            }
        };
        if (componentAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/LayeredPanel", "createWidthUpdater"));
        }
        return componentAdapter;
    }

    @NotNull
    private String getWidthPropertyName() {
        String string = "ATTACHED_TOOL_WINDOW." + this.myBenchName + "." + this.myToolName + ".WIDTH";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/LayeredPanel", "getWidthPropertyName"));
        }
        return string;
    }

    private int getToolWidth(@NotNull AttachedToolWindow<T> tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/LayeredPanel", "getToolWidth"));
        }
        return this.myPropertiesComponent.getInt(this.getWidthPropertyName(), tool.getDefinition().getInitialMinimumWidth());
    }

    private void setToolWidth(int width) {
        this.myPropertiesComponent.setValue(this.getWidthPropertyName(), width, -1);
    }
}

