/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.Split;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class MinimizedPanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private final SideModel<T> myModel;
    private final Side mySide;
    private final Component myFiller;
    private boolean myHasVisibleButtons;

    public MinimizedPanel(@NotNull Side side, @NotNull SideModel<T> model) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/MinimizedPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/MinimizedPanel", "<init>"));
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(IdeBorderFactory.createBorder((int)(side.isLeft() ? 4 : 1)));
        this.setPreferredSize(new Dimension(JBUI.scale((int)20), 0));
        this.setBackground((Color)JBColor.white);
        this.setOpaque(false);
        this.myModel = model;
        this.mySide = side;
        this.myFiller = Box.createVerticalGlue();
        model.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model, @NotNull SideModel.EventType unused) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/MinimizedPanel", "modelChanged"));
        }
        if (unused == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unused", "com/android/tools/adtui/workbench/MinimizedPanel", "modelChanged"));
        }
        this.removeAll();
        this.myHasVisibleButtons = false;
        model.getTopTools(this.mySide).forEach(this::addButton);
        this.add(this.myFiller);
        model.getBottomTools(this.mySide).forEach(this::addButton);
        this.setVisible(this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private void addButton(@NotNull AttachedToolWindow tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/MinimizedPanel", "addButton"));
        }
        AbstractButton button = tool.getMinimizedButton();
        button.setVisible(true);
        this.myHasVisibleButtons |= tool.isMinimized() || tool.isAutoHide();
        this.add(button);
    }

    public int drag(@NotNull AttachedToolWindow<T> tool, int position) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/MinimizedPanel", "drag"));
        }
        AbstractButton button = tool.getMinimizedButton();
        if (!this.isOpaque()) {
            this.enableMinimizeButtonDragAndDrop(true);
            button.setVisible(true);
        }
        int insertIndex = this.findInsertIndex(position, button);
        int index = this.getComponentIndex(button);
        if (index == insertIndex) {
            return insertIndex;
        }
        if (index >= 0) {
            this.remove(index);
        }
        this.add((Component)button, insertIndex);
        this.revalidate();
        this.repaint();
        return insertIndex;
    }

    public void dragExit(@NotNull AttachedToolWindow<T> tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/MinimizedPanel", "dragExit"));
        }
        tool.getMinimizedButton().setVisible(false);
        this.enableMinimizeButtonDragAndDrop(false);
        this.revalidate();
        this.repaint();
    }

    public void dragDrop(@NotNull AttachedToolWindow<T> tool, int position) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/MinimizedPanel", "dragDrop"));
        }
        int index = this.drag(tool, position);
        tool.getMinimizedButton().setVisible(false);
        int fillerIndex = this.getComponentIndex(this.myFiller);
        Split newSplit = index > fillerIndex ? Split.BOTTOM : Split.TOP;
        int toolIndex = newSplit.isBottom() ? index - fillerIndex - 1 : index;
        this.myModel.changeToolSettingsAfterDragAndDrop(tool, this.mySide, newSplit, toolIndex);
        this.enableMinimizeButtonDragAndDrop(false);
    }

    private void enableMinimizeButtonDragAndDrop(boolean enable) {
        this.setOpaque(enable);
        this.setVisible(enable || this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private int findInsertIndex(int position, @NotNull Component draggedButton) {
        if (draggedButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "draggedButton", "com/android/tools/adtui/workbench/MinimizedPanel", "findInsertIndex"));
        }
        int index = 0;
        int y = 0;
        int extraFillerHeight = draggedButton.getParent() == this ? draggedButton.getHeight() : 0;
        for (Component component : this.getComponents()) {
            if (component == draggedButton) continue;
            if (component instanceof Box.Filler) {
                if (position < y + (component.getHeight() + extraFillerHeight) / 2) {
                    return index;
                }
                ++index;
                y += extraFillerHeight;
            }
            if (position < (y += component.getHeight())) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    private int getComponentIndex(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/adtui/workbench/MinimizedPanel", "getComponentIndex"));
        }
        for (int index = 0; index < this.getComponentCount(); ++index) {
            if (this.getComponent(index) != component) continue;
            return index;
        }
        return -1;
    }
}

