/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SideModel<T> {
    private final List<AttachedToolWindow<T>> myAllTools;
    private final VisiblePair<T> myLeftVisibleTools;
    private final VisiblePair<T> myRightVisibleTools;
    private final List<Listener<T>> myListeners;
    private final Project myProject;
    private T myContext;
    private AttachedToolWindow<T> myVisibleAutoHideTool;

    public SideModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/SideModel", "<init>"));
        }
        this.myAllTools = new ArrayList<AttachedToolWindow<T>>(8);
        this.myLeftVisibleTools = new VisiblePair();
        this.myRightVisibleTools = new VisiblePair();
        this.myListeners = new ArrayList<Listener<T>>(2);
        this.myProject = project;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setContext(T context) {
        this.myContext = context;
        this.myAllTools.forEach(tool -> tool.setContext(context));
    }

    public T getContext() {
        return this.myContext;
    }

    public void addListener(@NotNull Listener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/adtui/workbench/SideModel", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @NotNull
    public List<AttachedToolWindow<T>> getAllTools() {
        List<AttachedToolWindow<T>> list = this.myAllTools;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getAllTools"));
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getVisibleTools(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "getVisibleTools"));
        }
        List<AttachedToolWindow> list = this.getVisibleTools(side.isLeft()).asList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getVisibleTools"));
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getHiddenTools(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "getHiddenTools"));
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "lambda$getHiddenTools$1"));
            }
            return tool.isMinimized() && !tool.isFloating() && !tool.isAutoHide() && tool.isLeft() == side.isLeft();
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getHiddenTools"));
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getTopTools(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "getTopTools"));
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "lambda$getTopTools$2"));
            }
            return !tool.isFloating() && tool.isLeft() == side.isLeft() && (!tool.isSplit() || tool.isAutoHide());
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getTopTools"));
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getBottomTools(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "getBottomTools"));
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "lambda$getBottomTools$3"));
            }
            return !tool.isFloating() && tool.isLeft() == side.isLeft() && tool.isSplit() && !tool.isAutoHide();
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getBottomTools"));
        }
        return list;
    }

    @Nullable
    public AttachedToolWindow<T> getVisibleAutoHideTool() {
        return this.myVisibleAutoHideTool;
    }

    @NotNull
    public List<AttachedToolWindow<T>> getHiddenSliders() {
        List<AttachedToolWindow<T>> list = this.myAllTools.stream().filter(tool -> tool.isAutoHide() && !tool.isFloating() && tool.isMinimized()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getHiddenSliders"));
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow<T>> getFloatingTools() {
        List<AttachedToolWindow<T>> list = this.myAllTools.stream().filter(AttachedToolWindow::isFloating).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getFloatingTools"));
        }
        return list;
    }

    public void setTools(@NotNull List<AttachedToolWindow<T>> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/SideModel", "setTools"));
        }
        tools.forEach(this::add);
        this.updateLocally();
    }

    private void add(@NotNull AttachedToolWindow<T> tool) {
        VisiblePair<T> visible;
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/SideModel", "add"));
        }
        this.myAllTools.add(tool);
        if (!(tool.isMinimized() || tool.isFloating() || (visible = this.getVisibleTools(tool.isLeft())).setIfEmpty(tool))) {
            tool.setMinimized(true);
        }
    }

    public void changeToolSettingsAfterDragAndDrop(@NotNull AttachedToolWindow<T> tool, @NotNull Side side, @NotNull Split split, int wantedSideToolIndex) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/SideModel", "changeToolSettingsAfterDragAndDrop"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/SideModel", "changeToolSettingsAfterDragAndDrop"));
        }
        if (split == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/android/tools/adtui/workbench/SideModel", "changeToolSettingsAfterDragAndDrop"));
        }
        tool.setLeft(side.isLeft());
        tool.setSplit(split.isBottom());
        List<AttachedToolWindow> list = split.isBottom() ? this.getBottomTools(side) : this.getTopTools(side);
        int index = list.indexOf(tool);
        if (index != wantedSideToolIndex && wantedSideToolIndex >= 0 && wantedSideToolIndex < list.size()) {
            int insertAfter = index < wantedSideToolIndex ? 1 : 0;
            this.myAllTools.remove(tool);
            this.myAllTools.add(this.myAllTools.indexOf(list.get(wantedSideToolIndex)) + insertAfter, tool);
        }
        this.update(Collections.singletonList(tool), EventType.UPDATE_TOOL_ORDER);
    }

    public void update(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.PropertyType typeOfChange) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/SideModel", "update"));
        }
        if (typeOfChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeOfChange", "com/android/tools/adtui/workbench/SideModel", "update"));
        }
        this.update(Collections.singletonList(tool), typeOfChange == AttachedToolWindow.PropertyType.FLOATING ? EventType.UPDATE_FLOATING_WINDOW : EventType.UPDATE);
    }

    public void updateLocally() {
        this.myLeftVisibleTools.removeBoth();
        this.myRightVisibleTools.removeBoth();
        this.update(this.myAllTools, EventType.LOCAL_UPDATE);
    }

    private void update(@NotNull List<AttachedToolWindow<T>> tools, @NotNull EventType eventType) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/SideModel", "update"));
        }
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/android/tools/adtui/workbench/SideModel", "update"));
        }
        for (AttachedToolWindow<T> tool : tools) {
            this.getVisibleTools(true).remove(tool);
            this.getVisibleTools(false).remove(tool);
            if (this.myVisibleAutoHideTool == tool) {
                this.myVisibleAutoHideTool = null;
            }
            if (tool.isMinimized() || tool.isFloating()) continue;
            if (tool.isAutoHide()) {
                if (this.myVisibleAutoHideTool != null) {
                    this.myVisibleAutoHideTool.setMinimized(true);
                }
                this.myVisibleAutoHideTool = tool;
                continue;
            }
            AttachedToolWindow<T> old = this.getVisibleTools(tool.isLeft()).set(tool.isSplit(), tool);
            if (old == null || old == tool) continue;
            old.setMinimized(true);
        }
        this.notifyListeners(eventType);
    }

    public void swap() {
        this.myAllTools.forEach(tool -> tool.setLeft(!tool.isLeft()));
        this.myLeftVisibleTools.swap(this.myRightVisibleTools);
        this.notifyListeners(EventType.SWAP);
    }

    private void notifyListeners(@NotNull EventType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/adtui/workbench/SideModel", "notifyListeners"));
        }
        this.myListeners.forEach(listener -> {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/adtui/workbench/SideModel", "lambda$notifyListeners$6"));
            }
            listener.modelChanged(this, type);
        });
    }

    @NotNull
    private VisiblePair<T> getVisibleTools(boolean isLeft) {
        VisiblePair<T> visiblePair = isLeft ? this.myLeftVisibleTools : this.myRightVisibleTools;
        if (visiblePair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel", "getVisibleTools"));
        }
        return visiblePair;
    }

    public static interface Listener<T> {
        public void modelChanged(@NotNull SideModel<T> var1, @NotNull EventType var2);
    }

    public static enum EventType {
        UPDATE,
        UPDATE_FLOATING_WINDOW,
        LOCAL_UPDATE,
        SWAP,
        UPDATE_TOOL_ORDER;

    }

    public static class VisiblePair<T> {
        @Nullable
        public AttachedToolWindow<T> myTop;
        @Nullable
        public AttachedToolWindow<T> myBottom;

        @Nullable
        public AttachedToolWindow<T> get(boolean isSplit) {
            return isSplit ? this.myBottom : this.myTop;
        }

        @Nullable
        public AttachedToolWindow<T> set(boolean isSplit, @Nullable AttachedToolWindow<T> tool) {
            AttachedToolWindow<T> old = this.get(isSplit);
            if (isSplit) {
                this.myBottom = tool;
            } else {
                this.myTop = tool;
            }
            return old;
        }

        public boolean setIfEmpty(@NotNull AttachedToolWindow<T> tool) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "setIfEmpty"));
            }
            if (this.get(tool.isSplit()) != null) {
                return false;
            }
            this.set(tool.isSplit(), tool);
            return true;
        }

        public void remove(@NotNull AttachedToolWindow<T> tool) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "remove"));
            }
            if (this.myTop == tool) {
                this.myTop = null;
            }
            if (this.myBottom == tool) {
                this.myBottom = null;
            }
        }

        public void removeBoth() {
            this.myTop = null;
            this.myBottom = null;
        }

        public void swap(@NotNull VisiblePair<T> other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "swap"));
            }
            this.myTop = other.set(false, this.myTop);
            this.myBottom = other.set(true, this.myBottom);
        }

        @NotNull
        public List<AttachedToolWindow> asList() {
            if (this.myTop == null && this.myBottom == null) {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "asList"));
                }
                return immutableList;
            }
            if (this.myTop == null || this.myBottom == null) {
                ImmutableList immutableList = ImmutableList.of(this.myTop == null ? this.myBottom : this.myTop);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "asList"));
                }
                return immutableList;
            }
            ImmutableList immutableList = ImmutableList.of(this.myTop, this.myBottom);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/SideModel$VisiblePair", "asList"));
            }
            return immutableList;
        }
    }
}

