/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;

public class CleanupDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create("Recycle", "Missing `recycle()` calls", "Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", Category.PERFORMANCE, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create("CommitTransaction", "Missing `commit()` calls", "After creating a `FragmentTransaction`, you typically need to commit it as well", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue SHARED_PREF = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue APPLY_SHARED_PREF = Issue.create("ApplySharedPref", "Use `apply()` on `SharedPreferences`", "Consider using `apply()` instead of `commit` on shared preferences. Whereas `commit` blocks and writes its data to persistent storage immediately, `apply` will handle it in the background.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_NOW = "commitNow";
    private static final String APPLY = "apply";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String EDIT = "edit";
    private static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    public static final String SURFACE_CLS = "android.view.Surface";
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    public static final String CURSOR_CLS = "android.database.Cursor";
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, EDIT);
    }

    @Override
    public List<String> getApplicableConstructorTypes() {
        return Arrays.asList(SURFACE_TEXTURE_CLS, SURFACE_CLS);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        String name = method.getName();
        if (BEGIN_TRANSACTION.equals(name)) {
            CleanupDetector.checkTransactionCommits(context, call, method);
        } else if (EDIT.equals(name)) {
            CleanupDetector.checkEditorApplied(context, call, method);
        } else {
            CleanupDetector.checkResourceRecycled(context, call, method);
        }
    }

    @Override
    public void visitConstructor(JavaContext context, JavaElementVisitor visitor, PsiNewExpression node, PsiMethod constructor) {
        String type;
        PsiClass containingClass = constructor.getContainingClass();
        if (containingClass != null && (type = containingClass.getQualifiedName()) != null) {
            CleanupDetector.checkRecycled(context, (PsiElement)node, type, RELEASE);
        }
    }

    private static void checkResourceRecycled(JavaContext context, PsiMethodCallExpression node, PsiMethod method) {
        String name = method.getName();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if ((OBTAIN.equals(name) || OBTAIN_NO_HISTORY.equals(name)) && evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
            CleanupDetector.checkRecycled(context, (PsiElement)node, MOTION_EVENT_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
            CleanupDetector.checkRecycled(context, (PsiElement)node, PARCEL_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) {
            CleanupDetector.checkRecycled(context, (PsiElement)node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((OBTAIN_STYLED_ATTRIBUTES.equals(name) || OBTAIN_ATTRIBUTES.equals(name) || OBTAIN_TYPED_ARRAY.equals(name)) && (evaluator.extendsClass(containingClass, "android.content.Context", false) || evaluator.extendsClass(containingClass, "android.content.res.Resources", false))) {
            PsiClass cls;
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiClassType && (cls = ((PsiClassType)returnType).resolve()) != null && "android.content.res.TypedArray".equals(cls.getQualifiedName())) {
                CleanupDetector.checkRecycled(context, (PsiElement)node, "android.content.res.TypedArray", RECYCLE);
            }
        } else if (ACQUIRE_CPC.equals(name) && evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) {
            CleanupDetector.checkRecycled(context, (PsiElement)node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((QUERY.equals(name) || RAW_QUERY.equals(name) || QUERY_WITH_FACTORY.equals(name) || RAW_QUERY_WITH_FACTORY.equals(name)) && (evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) || evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) || evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) || evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false))) {
            if (PsiTreeUtil.getParentOfType((PsiElement)node, PsiResourceVariable.class) != null) {
                return;
            }
            CleanupDetector.checkRecycled(context, (PsiElement)node, CURSOR_CLS, CLOSE);
        }
    }

    private static void checkRecycled(JavaContext context, PsiElement node, final String recycleType, final String recycleName) {
        PsiElement locationNode;
        PsiVariable boundVariable = CleanupDetector.getVariableElement(node);
        if (boundVariable == null) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true);
        if (method == null) {
            return;
        }
        FinishVisitor visitor = new FinishVisitor(context, boundVariable){

            @Override
            protected boolean isCleanupCall(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!recycleName.equals(methodName)) {
                    return false;
                }
                PsiMethod method = call.resolveMethod();
                if (method != null) {
                    PsiElement resolved;
                    PsiExpression operand;
                    PsiClass containingClass = method.getContainingClass();
                    if (this.mContext.getEvaluator().extendsClass(containingClass, recycleType, false) && (operand = methodExpression.getQualifierExpression()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                        return true;
                    }
                }
                return false;
            }
        };
        method.accept((PsiElementVisitor)visitor);
        if (visitor.isCleanedUp() || visitor.variableEscapes()) {
            return;
        }
        String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
        String message = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
        PsiElement psiElement = locationNode = node instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)node).getMethodExpression().getReferenceNameElement() : node;
        if (locationNode == null) {
            locationNode = node;
        }
        Location location = context.getLocation(locationNode);
        context.report(RECYCLE_RESOURCE, node, location, message);
    }

    private static void checkTransactionCommits(JavaContext context, PsiMethodCallExpression node, PsiMethod calledMethod) {
        if (CleanupDetector.isBeginTransaction(context, calledMethod)) {
            PsiVariable boundVariable = CleanupDetector.getVariableElement((PsiElement)node, true, true);
            if (boundVariable == null && CleanupDetector.isCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                    @Override
                    protected boolean isCleanupCall(PsiMethodCallExpression call) {
                        PsiExpression[] arguments;
                        if (CleanupDetector.isTransactionCommitMethodCall(this.mContext, call)) {
                            PsiExpression operand = call.getMethodExpression().getQualifierExpression();
                            if (operand != null) {
                                PsiElement resolved = this.mContext.getEvaluator().resolve((PsiElement)operand);
                                if (resolved != null && this.mVariables.contains(resolved)) {
                                    return true;
                                }
                                if (resolved instanceof PsiMethod && operand instanceof PsiMethodCallExpression && CleanupDetector.isCommittedInChainedCalls(this.mContext, (PsiMethodCallExpression)operand)) {
                                    while (operand instanceof PsiMethodCallExpression) {
                                        operand = ((PsiMethodCallExpression)operand).getMethodExpression().getQualifierExpression();
                                    }
                                    if (operand instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.isShowFragmentMethodCall(this.mContext, call) && (arguments = call.getArgumentList().getExpressions()).length == 2) {
                            PsiExpression first = arguments[0];
                            PsiElement resolved = this.mContext.getEvaluator().resolve((PsiElement)first);
                            if (resolved != null && this.mVariables.contains(resolved)) {
                                return true;
                            }
                        }
                        return false;
                    }
                };
                method.accept((PsiElementVisitor)commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            }
            String message = "This transaction should be completed with a `commit()` call";
            context.report(COMMIT_FRAGMENT, (PsiElement)node, context.getNameLocation((PsiElement)node), message);
        }
    }

    private static boolean isCommittedInChainedCalls(JavaContext context, PsiMethodCallExpression node) {
        PsiElement parent = LintUtils.skipParentheses(node.getParent());
        while (parent != null) {
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodInvocation = (PsiMethodCallExpression)parent;
                if (CleanupDetector.isTransactionCommitMethodCall(context, methodInvocation) || CleanupDetector.isShowFragmentMethodCall(context, methodInvocation)) {
                    return true;
                }
            } else if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            parent = LintUtils.skipParentheses(parent.getParent());
        }
        return false;
    }

    private static boolean isTransactionCommitMethodCall(JavaContext context, PsiMethodCallExpression call) {
        String methodName = call.getMethodExpression().getReferenceName();
        return (COMMIT.equals(methodName) || COMMIT_ALLOWING_LOSS.equals(methodName) || COMMIT_NOW_ALLOWING_LOSS.equals(methodName) || COMMIT_NOW.equals(methodName)) && CleanupDetector.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private static boolean isShowFragmentMethodCall(JavaContext context, PsiMethodCallExpression call) {
        String methodName = call.getMethodExpression().getReferenceName();
        return SHOW.equals(methodName) && CleanupDetector.isMethodOnFragmentClass(context, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private static boolean isMethodOnFragmentClass(JavaContext context, PsiMethodCallExpression call, String fragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        PsiMethod method = call.resolveMethod();
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
        }
        return returnForUnresolved;
    }

    private static void checkEditorApplied(JavaContext context, PsiMethodCallExpression node, PsiMethod calledMethod) {
        if (CleanupDetector.isSharedEditorCreation(context, calledMethod)) {
            PsiVariable boundVariable = CleanupDetector.getVariableElement((PsiElement)node, true, true);
            if (CleanupDetector.isEditorCommittedInChainedCalls(context, node)) {
                return;
            }
            if (boundVariable != null) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context, boundVariable){

                    @Override
                    protected boolean isCleanupCall(PsiMethodCallExpression call) {
                        PsiExpression operand;
                        if ((CleanupDetector.isEditorApplyMethodCall(this.mContext, call) || CleanupDetector.isEditorCommitMethodCall(this.mContext, call)) && (operand = call.getMethodExpression().getQualifierExpression()) != null) {
                            PsiElement resolved = this.mContext.getEvaluator().resolve((PsiElement)operand);
                            if (resolved != null && this.mVariables.contains(resolved)) {
                                return true;
                            }
                            if (resolved instanceof PsiMethod && operand instanceof PsiMethodCallExpression && CleanupDetector.isCommittedInChainedCalls(this.mContext, (PsiMethodCallExpression)operand)) {
                                while (operand instanceof PsiMethodCallExpression) {
                                    operand = ((PsiMethodCallExpression)operand).getMethodExpression().getQualifierExpression();
                                }
                                if (operand instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                                    return true;
                                }
                            } else if (resolved instanceof PsiMethod) {
                                while (operand instanceof PsiMethodCallExpression) {
                                    PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)operand).getMethodExpression();
                                    PsiType type = methodExpression.getType();
                                    if (type == null || !CleanupDetector.ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR.equals(type.getCanonicalText())) {
                                        operand = null;
                                        continue;
                                    }
                                    operand = methodExpression.getQualifierExpression();
                                }
                                if (operand instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                };
                method.accept((PsiElementVisitor)commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            } else if (PsiTreeUtil.getParentOfType((PsiElement)node, PsiReturnStatement.class) != null) {
                return;
            }
            String message = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
            context.report(SHARED_PREF, (PsiElement)node, context.getLocation((PsiElement)node), message);
        }
    }

    private static boolean isSharedEditorCreation(JavaContext context, PsiMethod method) {
        String methodName = method.getName();
        if (EDIT.equals(methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false);
        }
        return false;
    }

    private static boolean isEditorCommittedInChainedCalls(JavaContext context, PsiMethodCallExpression node) {
        PsiElement parent = LintUtils.skipParentheses(node.getParent());
        while (parent != null) {
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodInvocation = (PsiMethodCallExpression)parent;
                if (CleanupDetector.isEditorCommitMethodCall(context, methodInvocation) || CleanupDetector.isEditorApplyMethodCall(context, methodInvocation)) {
                    return true;
                }
            } else if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            parent = LintUtils.skipParentheses(parent.getParent());
        }
        return false;
    }

    private static boolean isEditorCommitMethodCall(JavaContext context, PsiMethodCallExpression call) {
        PsiMethod method;
        String methodName = call.getMethodExpression().getReferenceName();
        if (COMMIT.equals(methodName) && (method = call.resolveMethod()) != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false)) {
                CleanupDetector.suggestApplyIfApplicable(context, call);
                return true;
            }
        }
        return false;
    }

    private static boolean isEditorApplyMethodCall(JavaContext context, PsiMethodCallExpression call) {
        PsiMethod method;
        String methodName = call.getMethodExpression().getReferenceName();
        if (APPLY.equals(methodName) && (method = call.resolveMethod()) != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false);
        }
        return false;
    }

    private static void suggestApplyIfApplicable(JavaContext context, PsiMethodCallExpression node) {
        if (context.getProject().getMinSdkVersion().getApiLevel() >= 9) {
            PsiElement parent = LintUtils.skipParentheses(node.getParent());
            while (parent instanceof PsiReferenceExpression) {
                parent = LintUtils.skipParentheses(parent.getParent());
            }
            boolean returnValueIgnored = false;
            if (parent instanceof PsiMethodCallExpression || parent instanceof PsiNewExpression || parent instanceof PsiClass || parent instanceof PsiCodeBlock || parent instanceof PsiExpressionStatement) {
                returnValueIgnored = true;
            } else if (parent instanceof PsiStatement) {
                if (parent instanceof PsiIfStatement) {
                    returnValueIgnored = ((PsiIfStatement)parent).getCondition() != node;
                } else if (parent instanceof PsiWhileStatement) {
                    returnValueIgnored = ((PsiWhileStatement)parent).getCondition() != node;
                } else if (parent instanceof PsiDoWhileStatement) {
                    returnValueIgnored = ((PsiDoWhileStatement)parent).getCondition() != node;
                } else if (parent instanceof PsiAssertStatement) {
                    returnValueIgnored = ((PsiAssertStatement)parent).getAssertCondition() != node;
                } else {
                    boolean bl = returnValueIgnored = !(parent instanceof PsiReturnStatement) && !(parent instanceof PsiDeclarationStatement);
                }
            }
            if (returnValueIgnored && !LintDriver.isSuppressed(SHARED_PREF, (PsiAnnotationMemberValue)node)) {
                String message = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
                context.report(APPLY_SHARED_PREF, (PsiElement)node, context.getLocation((PsiElement)node), message);
            }
        }
    }

    public static PsiVariable getVariableElement(PsiElement rhs) {
        return CleanupDetector.getVariableElement(rhs, false, false);
    }

    public static PsiVariable getVariableElement(PsiElement rhs, boolean allowChainedCalls, boolean allowFields) {
        PsiElement parent = LintUtils.skipParentheses(rhs.getParent());
        if (allowChainedCalls) {
            PsiElement parentParent;
            while (parent instanceof PsiReferenceExpression && (parentParent = LintUtils.skipParentheses(parent.getParent())) instanceof PsiMethodCallExpression) {
                parent = LintUtils.skipParentheses(parentParent.getParent());
            }
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiElement resolved;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignment.getLExpression();
            if (lhs instanceof PsiReference && (resolved = ((PsiReference)lhs).resolve()) instanceof PsiVariable && (allowFields || !(resolved instanceof PsiField))) {
                return (PsiVariable)resolved;
            }
        } else if (parent instanceof PsiVariable && (allowFields || !(parent instanceof PsiField))) {
            return (PsiVariable)parent;
        }
        return null;
    }

    private static boolean isBeginTransaction(JavaContext context, PsiMethod method) {
        String methodName = method.getName();
        if (BEGIN_TRANSACTION.equals(methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    private static abstract class FinishVisitor
    extends JavaRecursiveElementVisitor {
        protected final JavaContext mContext;
        protected final List<PsiVariable> mVariables;
        private final PsiVariable mOriginalVariableNode;
        private boolean mContainsCleanup;
        private boolean mEscapes;

        public FinishVisitor(JavaContext context, PsiVariable variableNode) {
            this.mContext = context;
            this.mOriginalVariableNode = variableNode;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variableNode});
        }

        public boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public void visitElement(PsiElement element) {
            if (!this.mContainsCleanup) {
                super.visitElement(element);
            }
        }

        protected abstract boolean isCleanupCall(PsiMethodCallExpression var1);

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (this.mContainsCleanup) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (!this.mEscapes) {
                for (PsiExpression expression : call.getArgumentList().getExpressions()) {
                    PsiElement resolved;
                    if (!(expression instanceof PsiReferenceExpression) || (resolved = ((PsiReferenceExpression)expression).resolve()) == null || !this.mVariables.contains(resolved)) continue;
                    boolean wasEscaped = this.mEscapes;
                    this.mEscapes = true;
                    if (!CleanupDetector.OBTAIN.equals(call.getMethodExpression().getReferenceName())) continue;
                    PsiMethod method = call.resolveMethod();
                    if (!this.mContext.getEvaluator().isMemberInClass((PsiMember)method, CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.mEscapes = wasEscaped;
                }
            }
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
            }
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            PsiElement resolved;
            super.visitLocalVariable(variable);
            PsiExpression initializer = variable.getInitializer();
            if (initializer instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mVariables.add((PsiVariable)variable);
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiElement lhs;
            PsiElement resolved;
            super.visitAssignmentExpression(expression);
            boolean clearLhs = false;
            PsiExpression rhs = expression.getRExpression();
            if (rhs instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                clearLhs = false;
                PsiElement lhs2 = this.mContext.getEvaluator().resolve((PsiElement)expression.getLExpression());
                if (lhs2 instanceof PsiLocalVariable) {
                    this.mVariables.add((PsiVariable)((PsiLocalVariable)lhs2));
                } else if (lhs2 instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            if (clearLhs && (lhs = this.mContext.getEvaluator().resolve((PsiElement)expression.getLExpression())) != null && !lhs.equals(this.mOriginalVariableNode) && this.mVariables.contains(lhs)) {
                this.mVariables.remove(lhs);
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiElement resolved;
            PsiExpression returnValue = statement.getReturnValue();
            if (returnValue instanceof PsiReference && (resolved = ((PsiReference)returnValue).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mEscapes = true;
            }
            super.visitReturnStatement(statement);
        }
    }
}

