/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.Printer;
import com.android.tools.perflib.heap.memoryanalyzer.Report;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class DuplicatedStringsReport
implements Report {
    private List<AnalysisResultEntry<?>> mResults;
    private static final int MAX_VALUE_STRING_LENGTH = 100;

    @Override
    public void generate(List<AnalysisResultEntry<?>> results) {
        Collections.sort(results, Collections.reverseOrder(new Comparator<AnalysisResultEntry<?>>(){

            @Override
            public int compare(AnalysisResultEntry<?> o1, AnalysisResultEntry<?> o2) {
                return DuplicatedStringsReport.this.getConsumedBytes(o1) - DuplicatedStringsReport.this.getConsumedBytes(o2);
            }
        }));
        this.mResults = results;
    }

    @Override
    public void print(Printer printer) {
        DuplicatedStringsAnalyzerTask task = new DuplicatedStringsAnalyzerTask();
        printer.addHeading(2, task.getTaskName() + " Report");
        printer.addParagraph(task.getTaskDescription());
        if (this.mResults == null || this.mResults.isEmpty()) {
            printer.addParagraph("No issues found.");
            return;
        }
        printer.startTable("Value", "Bytes", "Duplicates", "First Duplicate");
        for (AnalysisResultEntry<?> entry : this.mResults) {
            String value = entry.getOffender().getOffendingDescription();
            if (value.length() > 100) {
                value = value.substring(0, 100) + "...";
            }
            String consumedBytes = Integer.toString(this.getConsumedBytes(entry));
            String duplicates = Integer.toString(entry.getOffender().getOffenders().size());
            String instance = printer.formatInstance((Instance)entry.getOffender().getOffenders().get(0));
            printer.addRow(value, consumedBytes, duplicates, instance);
        }
        printer.endTable();
    }

    private int getConsumedBytes(AnalysisResultEntry<?> entry) {
        return entry.getOffender().getOffendingDescription().length() * entry.getOffender().getOffenders().size();
    }
}

