/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import org.editorconfig.configmanagement.EditorSettingsManager;
import org.editorconfig.configmanagement.EncodingManager;
import org.editorconfig.configmanagement.LineEndingsManager;
import org.jetbrains.annotations.NotNull;

public class ConfigProjectComponent
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/editorconfig/plugincomponents/ConfigProjectComponent", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final EditorFactory editorFactory = EditorFactory.getInstance();
        MessageBus bus = project.getMessageBus();
        EditorSettingsManager editorSettingsManager = new EditorSettingsManager(project);
        EncodingManager encodingManager = new EncodingManager(project);
        LineEndingsManager lineEndingsManager = new LineEndingsManager(project);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)encodingManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)editorSettingsManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)lineEndingsManager);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "fileCreated"));
                }
                this.updateOpenEditors(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "fileDeleted"));
                }
                this.updateOpenEditors(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "contentsChanged"));
                }
                this.updateOpenEditors(event);
            }

            private void updateOpenEditors(VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (".editorconfig".equals(file.getName()) && (ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file) || !Registry.is((String)"editor.config.stop.at.project.root"))) {
                    for (Editor editor : editorFactory.getAllEditors()) {
                        if (editor.isDisposed()) continue;
                        ((EditorEx)editor).reinitSettings();
                    }
                }
            }
        }, (Disposable)project);
    }
}

