/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import icons.AndroidIcons;
import java.awt.Dimension;
import java.net.URL;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidAssetStudioAction
extends AnAction {
    protected AndroidAssetStudioAction(@Nullable String text, @Nullable String description) {
        super(text, description, AndroidIcons.Android);
    }

    protected static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return module != null && view != null && view.getDirectories().length != 0 && AndroidFacet.getInstance(module) != null;
    }

    public final void update(AnActionEvent e) {
        e.getPresentation().setVisible(AndroidAssetStudioAction.isAvailable(e.getDataContext()));
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        ModelWizard wizard = this.createWizard(facet);
        if (wizard != null) {
            StudioWizardDialogBuilder dialogBuilder = new StudioWizardDialogBuilder(wizard, "Asset Studio");
            dialogBuilder.setProject(facet.getModule().getProject()).setMinimumSize(this.getWizardSize()).setHelpUrl(this.getHelpUrl());
            dialogBuilder.build().show();
        }
    }

    @Nullable
    protected abstract ModelWizard createWizard(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract Dimension getWizardSize();

    @Nullable
    protected URL getHelpUrl() {
        return null;
    }
}

