/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.actions.AndroidAssetStudioAction;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateVectorIconModel;
import com.android.tools.idea.npw.assetstudio.wizard.NewVectorAssetStep;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.net.URL;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewVectorAssetAction
extends AndroidAssetStudioAction {
    private static final String ERROR_TITLE = "Newer Android Plugin for Gradle Required";
    private static final String ERROR_MESSAGE = "<html><p>To support vector assets when your minimal SDK version is less than 21,<br>the Android plugin for Gradle version must be 1.4 or above.<br>This will allow Android Studio to convert vector assets into PNG images at build time.</p><p>See <a href=\"https://developer.android.com/tools/building/plugin-for-gradle.html#projectBuildFile\">here</a> for how to update the version of Android plugin for Gradle.</p></html>";
    private static final GradleVersion VECTOR_ASSET_GENERATION_REVISION = new GradleVersion(1, 4, 0);
    private static final int VECTOR_DRAWABLE_API_LEVEL = 21;

    public NewVectorAssetAction() {
        super("Vector Asset", "Open Vector Asset Studio to create an image asset");
    }

    @Override
    @Nullable
    protected ModelWizard createWizard(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/actions/NewVectorAssetAction", "createWizard"));
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            AndroidVersion minSdkVersion = androidModel.getMinSdkVersion();
            String version = androidModel.getAndroidProject().getModelVersion();
            GradleVersion revision = GradleVersion.parse((String)version);
            if (revision.compareIgnoringQualifiers(VECTOR_ASSET_GENERATION_REVISION) < 0 && (minSdkVersion == null || minSdkVersion.getApiLevel() < 21)) {
                Messages.showErrorDialog((Project)project, (String)ERROR_MESSAGE, (String)ERROR_TITLE);
                return null;
            }
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new NewVectorAssetStep(new GenerateVectorIconModel(facet), facet));
        return wizardBuilder.build();
    }

    @Override
    @NotNull
    protected Dimension getWizardSize() {
        JBDimension jBDimension = JBUI.size((int)700, (int)500);
        if (jBDimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/NewVectorAssetAction", "getWizardSize"));
        }
        return jBDimension;
    }

    @Override
    @Nullable
    protected URL getHelpUrl() {
        return WizardUtils.toUrl("http://developer.android.com/tools/help/vector-asset-studio.html");
    }
}

