/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassNavigation
implements NavigationItem {
    @NotNull
    private PsiFile myPsiFile;
    private int myOffset;
    private int myLine;

    private PsiClassNavigation(@NotNull PsiFile file, int offset, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/actions/PsiClassNavigation", "<init>"));
        }
        this.myPsiFile = file;
        this.myOffset = offset;
        this.myLine = line;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/PsiClassNavigation", "getNavigationForClass"));
        }
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] resolvedClasses = PsiClassNavigation.resolveClasses(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[resolvedClasses.length];
        for (int i = 0; i < resolvedClasses.length; ++i) {
            PsiClass c = resolvedClasses[i];
            navigatables[i] = new PsiClassNavigation(c.getContainingFile(), c.getTextOffset(), -1);
        }
        return navigatables;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/PsiClassNavigation", "getNavigationForClass"));
        }
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[psiClasses.length];
        for (int i = 0; i < psiClasses.length; ++i) {
            PsiClass c = psiClasses[i];
            navigatables[i] = new PsiClassNavigation(c.getContainingFile(), -1, line);
        }
        return navigatables;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(PsiClassNavigation.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "getLog"));
        }
        return logger;
    }

    @NotNull
    private static PsiClass[] resolveClasses(@NotNull Project project, @NotNull String className) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/PsiClassNavigation", "resolveClasses"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/actions/PsiClassNavigation", "resolveClasses"));
        }
        PsiClass[] psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className);
        if (psiClasses.length == 0) {
            if (psiClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "resolveClasses"));
            }
            return psiClasses;
        }
        String[] classNameComponents = className.split("\\$");
        if (classNameComponents.length == 1) {
            if (psiClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "resolveClasses"));
            }
            return psiClasses;
        }
        block0: for (int psiClassIndex = 0; psiClassIndex < psiClasses.length; ++psiClassIndex) {
            for (int i = 1; i < classNameComponents.length; ++i) {
                String innerClassName = classNameComponents[i];
                if (PsiClassNavigation.startsWithInteger(innerClassName)) {
                    int innerClassIndex = PsiClassNavigation.convertToClassIndex(innerClassName);
                    if (innerClassIndex < 0) {
                        PsiClassNavigation.getLog().info("Attempted to resolve mismatched class name in hprof file: " + className);
                        continue block0;
                    }
                    CountDownAnonymousClassVisitor visitor = new CountDownAnonymousClassVisitor(innerClassIndex);
                    psiClasses[psiClassIndex].accept((PsiElementVisitor)visitor);
                    PsiAnonymousClass anonymousClass = visitor.getAnonymousClass();
                    if (anonymousClass == null) continue block0;
                    psiClasses[psiClassIndex] = anonymousClass;
                    continue;
                }
                PsiClass innerClass = psiClasses[psiClassIndex].findInnerClassByName(innerClassName, false);
                if (innerClass == null) continue block0;
                psiClasses[psiClassIndex] = innerClass;
            }
        }
        if (psiClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "resolveClasses"));
        }
        return psiClasses;
    }

    @NotNull
    private static PsiClass[] getPsiClassesForOuterClass(@NotNull Project project, @NotNull String className) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/actions/PsiClassNavigation", "getPsiClassesForOuterClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/actions/PsiClassNavigation", "getPsiClassesForOuterClass"));
        }
        String outerClassName = PsiClassNavigation.getOuterClassName(className);
        if (outerClassName == null) {
            PsiClass[] psiClassArray = new PsiClass[]{};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "getPsiClassesForOuterClass"));
            }
            return psiClassArray;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.projectScope((Project)project));
        if (psiClasses.length == 0) {
            psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.allScope((Project)project));
        }
        block0: for (int i = 0; i < psiClasses.length; ++i) {
            PsiClass[] sourcePsiClasses;
            PsiElement fileElement;
            PsiClass psiClass = psiClasses[i];
            if (psiClass.getQualifiedName() == null || !(psiClass instanceof PsiCompiledElement) || (fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement || !(fileElement instanceof PsiJavaFile)) continue;
            for (PsiClass sourcePsiClass : sourcePsiClasses = ((PsiJavaFile)fileElement).getClasses()) {
                if (!psiClass.getQualifiedName().equals(sourcePsiClass.getQualifiedName())) continue;
                psiClasses[i] = sourcePsiClass;
                continue block0;
            }
        }
        if (psiClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "getPsiClassesForOuterClass"));
        }
        return psiClasses;
    }

    @Nullable
    private static String getOuterClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/actions/PsiClassNavigation", "getOuterClassName"));
        }
        int innerClassSymbolIndex = className.indexOf("$");
        if (innerClassSymbolIndex > 0) {
            return className.substring(0, innerClassSymbolIndex);
        }
        if (innerClassSymbolIndex == 0) {
            PsiClassNavigation.getLog().warn("Invalid class name: starts with '$'");
            return null;
        }
        return className;
    }

    private static int convertToClassIndex(@NotNull String innerClassNameString) {
        if (innerClassNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassNameString", "com/android/tools/idea/actions/PsiClassNavigation", "convertToClassIndex"));
        }
        try {
            return Integer.parseInt(innerClassNameString) - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean startsWithInteger(@NotNull String target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/actions/PsiClassNavigation", "startsWithInteger"));
        }
        return !target.isEmpty() && Character.isDigit(target.charAt(0));
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/PsiClassNavigation", "getPsiFile"));
        }
        return psiFile;
    }

    @Nullable
    public String getName() {
        return this.myPsiFile.getName();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this.myPsiFile.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor fileDescriptor = this.myOffset >= 0 ? new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myOffset) : new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myLine, 0);
        fileDescriptor.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myPsiFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myPsiFile.canNavigateToSource();
    }

    private static class CountDownAnonymousClassVisitor
    extends JavaRecursiveElementVisitor {
        @Nullable
        private PsiAnonymousClass myAnonymousClass;
        private int myAnonymousClassIndex;

        public CountDownAnonymousClassVisitor(int anonymousClassIndex) {
            this.myAnonymousClassIndex = anonymousClassIndex;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (this.myAnonymousClassIndex == 0) {
                this.myAnonymousClass = aClass;
            }
            --this.myAnonymousClassIndex;
        }

        @Nullable
        public PsiAnonymousClass getAnonymousClass() {
            return this.myAnonymousClass;
        }
    }
}

