/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class LicenseTextCollector {
    private final Path myHome;
    private final List<Path> myLicenses;

    public LicenseTextCollector(@NotNull Path ideHome, @NotNull List<Path> licenses) {
        if (ideHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideHome", "com/android/tools/idea/actions/license/LicenseTextCollector", "<init>"));
        }
        if (licenses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenses", "com/android/tools/idea/actions/license/LicenseTextCollector", "<init>"));
        }
        this.myHome = ideHome;
        this.myLicenses = licenses;
    }

    @NotNull
    public CompletableFuture<String> getLicenseText() {
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(this::getLicenseTextSync);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicenseTextCollector", "getLicenseText"));
        }
        return completableFuture;
    }

    private String getLicenseTextSync() {
        StringBuilder sb = new StringBuilder(10240);
        for (Path license : this.myLicenses) {
            sb.append("------------ License file: ");
            sb.append(this.myHome.relativize(license).toString());
            sb.append("------------");
            sb.append("<br><br>");
            sb.append(LicenseTextCollector.getLicenseText(license.toFile()));
            sb.append("<br><br>");
        }
        return sb.toString();
    }

    @NotNull
    private static String getLicenseText(@NotNull File f) {
        String string;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/actions/license/LicenseTextCollector", "getLicenseText"));
        }
        try {
            string = Files.toString((File)f, (Charset)Charsets.UTF_8).replaceAll("\\<.*?\\>", "").replace("\n", "<br>");
        }
        catch (IOException e) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicenseTextCollector", "getLicenseText"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/license/LicenseTextCollector", "getLicenseText"));
        }
        return string;
    }
}

