/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.io.IAbstractFile;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.SparseIntArray;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.android.uipreview.VirtualFileWrapper;
import org.jetbrains.android.util.BufferingFileWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ConfigurationMatcher");
    private final Configuration myConfiguration;
    private final ConfigurationManager myManager;
    private final VirtualFile myFile;
    private final LocalResourceRepository myResources;

    public ConfigurationMatcher(@NotNull Configuration configuration, @Nullable LocalResourceRepository resources, @Nullable VirtualFile file) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/ConfigurationMatcher", "<init>"));
        }
        this.myConfiguration = configuration;
        this.myFile = file;
        this.myResources = resources;
        this.myManager = this.myConfiguration.getConfigurationManager();
    }

    public boolean isCurrentFileBestMatchFor(@NotNull FolderConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/idea/configurations/ConfigurationMatcher", "isCurrentFileBestMatchFor"));
        }
        if (this.myResources != null && this.myFile != null) {
            VirtualFile match = this.myResources.getMatchingFile(this.myFile, this.getResourceType(), config);
            if (match != null) {
                return this.myFile.equals(match);
            }
            LOG.debug("Current file is not a match for the given config.");
        }
        return false;
    }

    private ResourceType getResourceType() {
        List related;
        ResourceFolderType folderType;
        String parentName;
        ResourceType type = ResourceType.LAYOUT;
        VirtualFile parent = this.myFile.getParent();
        if (parent != null && !(parentName = parent.getName()).startsWith("layout") && (folderType = ResourceHelper.getFolderType(this.myFile)) != null && !(related = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
            type = (ResourceType)related.get(0);
        }
        return type;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull IAbstractFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/ConfigurationMatcher", "getVirtualFile"));
        }
        if (file instanceof VirtualFileWrapper) {
            return ((VirtualFileWrapper)file).getFile();
        }
        if (file instanceof BufferingFileWrapper) {
            BufferingFileWrapper wrapper = (BufferingFileWrapper)file;
            File ioFile = wrapper.getFile();
            return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
        }
        LOG.warn("Unexpected type of match file: " + file.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> getBestFileMatches() {
        if (this.myResources != null && this.myFile != null) {
            FolderConfiguration config = this.myConfiguration.getFullConfig();
            VersionQualifier prevQualifier = config.getVersionQualifier();
            config.setVersionQualifier(null);
            List<VirtualFile> list = this.myResources.getMatchingFiles(this.myFile, this.getResourceType(), config);
            List<VirtualFile> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMatcher", "getBestFileMatches"));
            }
            return list2;
            finally {
                config.setVersionQualifier(prevQualifier);
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMatcher", "getBestFileMatches"));
        }
        return list;
    }

    @NotNull
    public List<com.android.tools.idea.rendering.Locale> getPrioritizedLocales() {
        List<com.android.tools.idea.rendering.Locale> projectLocales = this.myManager.getLocales();
        ArrayList<com.android.tools.idea.rendering.Locale> locales = new ArrayList<com.android.tools.idea.rendering.Locale>(projectLocales.size() + 1);
        com.android.tools.idea.rendering.Locale current = this.myManager.getLocale();
        locales.add(current);
        for (com.android.tools.idea.rendering.Locale locale : projectLocales) {
            if (locale.equals(current)) continue;
            locales.add(locale);
        }
        ArrayList<com.android.tools.idea.rendering.Locale> arrayList = locales;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMatcher", "getPrioritizedLocales"));
        }
        return arrayList;
    }

    void adaptConfigSelection(boolean needBestMatch) {
        FolderConfiguration currentConfig;
        boolean needConfigChange = true;
        boolean currentConfigIsCompatible = false;
        State selectedState = this.myConfiguration.getDeviceState();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        Module module = this.myConfiguration.getModule();
        if (selectedState != null && (currentConfig = Configuration.getFolderConfig(module, selectedState, this.myConfiguration.getLocale(), this.myConfiguration.getTarget())) != null && editedConfig.isMatchFor(currentConfig)) {
            currentConfigIsCompatible = true;
            if (!needBestMatch || this.isCurrentFileBestMatchFor(currentConfig)) {
                needConfigChange = false;
            }
        }
        if (needConfigChange) {
            List<com.android.tools.idea.rendering.Locale> localeList = this.getPrioritizedLocales();
            FolderConfiguration testConfig = new FolderConfiguration();
            State matchState = null;
            int localeIndex = -1;
            Device device = this.myConfiguration.getDevice();
            IAndroidTarget target = this.myConfiguration.getTarget();
            if (device != null && target != null) {
                VersionQualifier versionQualifier = new VersionQualifier(target.getVersion().getFeatureLevel());
                block0: for (State state : device.getAllStates()) {
                    testConfig.set(Configuration.getFolderConfig(module, state, this.myConfiguration.getLocale(), target));
                    testConfig.setVersionQualifier(versionQualifier);
                    for (int i = 0; i < localeList.size(); ++i) {
                        com.android.tools.idea.rendering.Locale locale = localeList.get(i);
                        testConfig.setLocaleQualifier(locale.qualifier);
                        if (!editedConfig.isMatchFor(testConfig) || !this.isCurrentFileBestMatchFor(testConfig)) continue;
                        matchState = state;
                        localeIndex = i;
                        break block0;
                    }
                }
            }
            if (matchState != null) {
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setDeviceState(matchState);
                this.myConfiguration.setEffectiveDevice(device, matchState);
                this.myConfiguration.finishBulkEditing();
            } else {
                this.findAndSetCompatibleConfig(currentConfigIsCompatible);
            }
        }
    }

    void findAndSetCompatibleConfig(boolean favorCurrentConfig) {
        ConfigMatch match;
        int max;
        int start;
        List<com.android.tools.idea.rendering.Locale> localeList = this.getPrioritizedLocales();
        List<Device> deviceList = this.myManager.getDevices();
        FolderConfiguration editedConfig = this.myConfiguration.getEditedConfig();
        FolderConfiguration currentConfig = this.myConfiguration.getFullConfig();
        ArrayList<ConfigMatch> anyMatches = new ArrayList<ConfigMatch>();
        ArrayList<ConfigMatch> bestMatches = new ArrayList<ConfigMatch>();
        int localeHostMatch = this.getLocaleMatch();
        ArrayList<ConfigBundle> configBundles = new ArrayList<ConfigBundle>(200);
        if (editedConfig.getLocaleQualifier() != null || localeHostMatch == -1) {
            start = 0;
            max = localeList.size();
        } else {
            start = localeHostMatch;
            max = localeHostMatch + 1;
        }
        for (int i = start; i < max; ++i) {
            com.android.tools.idea.rendering.Locale l = localeList.get(i);
            ConfigBundle bundle = new ConfigBundle();
            bundle.config.setLocaleQualifier(l.qualifier);
            bundle.localeIndex = i;
            configBundles.add(bundle);
        }
        ConfigurationMatcher.addDockModeToBundles(configBundles);
        ConfigurationMatcher.addNightModeToBundles(configBundles);
        this.addRenderTargetToBundles(configBundles);
        com.android.tools.idea.rendering.Locale currentLocale = this.myConfiguration.getLocale();
        IAndroidTarget currentTarget = this.myConfiguration.getTarget();
        Module module = this.myConfiguration.getModule();
        for (Device device : deviceList) {
            for (State state : device.getAllStates()) {
                FolderConfiguration stateConfig = Configuration.getFolderConfig(module, state, currentLocale, currentTarget);
                for (ConfigBundle bundle : configBundles) {
                    FolderConfiguration testConfig = new FolderConfiguration();
                    testConfig.set(stateConfig);
                    testConfig.add(bundle.config);
                    if (!editedConfig.isMatchFor(testConfig)) continue;
                    anyMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                    if (!this.isCurrentFileBestMatchFor(testConfig)) continue;
                    bestMatches.add(new ConfigMatch(testConfig, device, state, bundle));
                }
            }
        }
        if (bestMatches.size() == 0) {
            if (favorCurrentConfig) {
                if (!editedConfig.isMatchFor(currentConfig)) {
                    LOG.warn("favorCurrentConfig can only be true if the current config is compatible");
                }
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with '%3$s'.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            } else if (anyMatches.size() > 0) {
                match = this.selectConfigMatch(anyMatches);
                this.myConfiguration.startBulkEditing();
                this.myConfiguration.setEffectiveDevice(match.device, match.state);
                this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
                this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
                this.myConfiguration.finishBulkEditing();
                LOG.warn(String.format("'%1$s' is not a best match for any device/locale combination for %2$s.\nDisplaying it with\n  %3$s\nwhich is compatible, but will actually be displayed with another more specific version of the layout.", editedConfig.toDisplayString(), this.myConfiguration.getFile(), currentConfig.toDisplayString()));
            }
        } else {
            match = this.selectConfigMatch(bestMatches);
            this.myConfiguration.startBulkEditing();
            this.myConfiguration.setEffectiveDevice(match.device, match.state);
            this.myConfiguration.setUiMode(UiMode.getByIndex((int)match.bundle.dockModeIndex));
            this.myConfiguration.setNightMode(NightMode.getByIndex((int)match.bundle.nightModeIndex));
            this.myConfiguration.finishBulkEditing();
        }
    }

    private void addRenderTargetToBundles(List<ConfigBundle> configBundles) {
        IAndroidTarget target = this.myManager.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            for (ConfigBundle bundle : configBundles) {
                bundle.config.setVersionQualifier(new VersionQualifier(apiLevel));
            }
        }
    }

    private static void addDockModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            for (UiMode mode : UiMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle);
                b.config.setUiModeQualifier(new UiModeQualifier(mode));
                b.dockModeIndex = index++;
                list.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private static void addNightModeToBundles(List<ConfigBundle> addConfig) {
        ArrayList<ConfigBundle> list = new ArrayList<ConfigBundle>();
        for (ConfigBundle bundle : addConfig) {
            int index = 0;
            for (NightMode mode : NightMode.values()) {
                ConfigBundle b = new ConfigBundle(bundle);
                b.config.setNightModeQualifier(new NightModeQualifier(mode));
                b.nightModeIndex = index++;
                list.add(b);
            }
        }
        addConfig.clear();
        addConfig.addAll(list);
    }

    private int getLocaleMatch() {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != null) {
            LocaleQualifier qualifier;
            com.android.tools.idea.rendering.Locale locale;
            int l;
            String currentLanguage = defaultLocale.getLanguage();
            String currentRegion = defaultLocale.getCountry();
            List<com.android.tools.idea.rendering.Locale> localeList = this.myManager.getLocales();
            int count = localeList.size();
            for (l = 0; l < count; ++l) {
                locale = localeList.get(l);
                qualifier = locale.qualifier;
                if (!qualifier.getLanguage().equals(currentLanguage) || qualifier.getRegion() != null && !qualifier.getRegion().equals(currentRegion)) continue;
                return l;
            }
            for (l = 0; l < count; ++l) {
                locale = localeList.get(l);
                qualifier = locale.qualifier;
                if (!qualifier.getLanguage().equals(currentLanguage)) continue;
                return l;
            }
        }
        return 0;
    }

    @NotNull
    private ConfigMatch selectConfigMatch(@NotNull List<ConfigMatch> matches) {
        FileDocumentManager documentManager;
        VirtualFile file;
        Editor activeEditor;
        int apiLevel;
        if (matches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matches", "com/android/tools/idea/configurations/ConfigurationMatcher", "selectConfigMatch"));
        }
        List<String> deviceIds = this.myManager.getStateManager().getProjectState().getDeviceIds();
        HashMap idRank = Maps.newHashMapWithExpectedSize((int)deviceIds.size());
        int rank = 0;
        for (String id : deviceIds) {
            idRank.put(id, rank++);
        }
        Comparator<ConfigMatch> comparator = null;
        IAndroidTarget projectTarget = this.myManager.getProjectTarget();
        if (projectTarget != null && (apiLevel = projectTarget.getVersion().getFeatureLevel()) >= 11 && apiLevel < 14) {
            comparator = new TabletConfigComparator(idRank);
        }
        if (comparator == null) {
            comparator = new PhoneConfigComparator(idRank);
        }
        Collections.sort(matches, comparator);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myManager.getProject());
        if (editorManager instanceof FileEditorManagerImpl && (activeEditor = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true)) != null && (file = (documentManager = FileDocumentManager.getInstance()).getFile(activeEditor.getDocument())) != null && !file.equals(this.myFile) && file.getFileType() == StdFileTypes.XML && ResourceHelper.getFolderType(this.myFile) == ResourceHelper.getFolderType(file)) {
            Configuration configuration = this.myManager.getConfiguration(file);
            FolderConfiguration fullConfig = configuration.getFullConfig();
            for (ConfigMatch match : matches) {
                if (!fullConfig.equals((Object)match.testConfig)) continue;
                ConfigMatch configMatch = match;
                if (configMatch == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMatcher", "selectConfigMatch"));
                }
                return configMatch;
            }
        }
        ConfigMatch configMatch = matches.get(0);
        if (configMatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMatcher", "selectConfigMatch"));
        }
        return configMatch;
    }

    @Nullable
    public static VirtualFile getBetterMatch(@NotNull Configuration configuration, @Nullable Device device, @Nullable String stateName, @Nullable com.android.tools.idea.rendering.Locale locale, @Nullable IAndroidTarget target) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/ConfigurationMatcher", "getBetterMatch"));
        }
        VirtualFile file = configuration.getFile();
        Module module = configuration.getModule();
        if (file != null && module != null) {
            ResourceType type;
            List<VirtualFile> matches;
            List types;
            ResourceFolderType folderType;
            AppResourceRepository resources;
            FolderConfiguration currentConfig;
            State selectedState;
            if (device == null) {
                device = configuration.getDevice();
            }
            if (stateName == null) {
                State deviceState = configuration.getDeviceState();
                String string = stateName = deviceState != null ? deviceState.getName() : null;
            }
            if ((selectedState = ConfigurationFileState.getState(device, stateName)) == null) {
                return null;
            }
            if (locale == null) {
                locale = configuration.getLocale();
            }
            if (target == null) {
                target = configuration.getTarget();
            }
            if (!((currentConfig = Configuration.getFolderConfig(module, selectedState, locale, target)) == null || (resources = AppResourceRepository.getAppResources(module, true)) == null || (folderType = ResourceHelper.getFolderType(file)) == null || (types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty() || (matches = resources.getMatchingFiles(file, type = (ResourceType)types.get(0), currentConfig)).contains(file) || matches.isEmpty())) {
                return matches.get(0);
            }
        }
        return null;
    }

    private static class PhoneConfigComparator
    implements Comparator<ConfigMatch> {
        private static final String PREFERRED_ID = "Nexus 4";
        private final SparseIntArray mDensitySort = new SparseIntArray(4);
        private final Map<String, Integer> mIdRank;

        public PhoneConfigComparator(Map<String, Integer> idRank) {
            int i = 0;
            this.mDensitySort.put(Density.HIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.MEDIUM.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_400.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_560.getDpiValue(), ++i);
            this.mDensitySort.put(Density.XXXHIGH.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_420.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_360.getDpiValue(), ++i);
            this.mDensitySort.put(Density.DPI_280.getDpiValue(), ++i);
            this.mDensitySort.put(Density.TV.getDpiValue(), ++i);
            this.mDensitySort.put(Density.LOW.getDpiValue(), ++i);
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            int dpi1 = 160;
            int dpi2 = 160;
            DensityQualifier dpiQualifier1 = config1.getDensityQualifier();
            if (dpiQualifier1 != null) {
                Density value = dpiQualifier1.getValue();
                dpi1 = value != null ? value.getDpiValue() : 160;
            }
            dpi1 = this.mDensitySort.get(dpi1, 100);
            DensityQualifier dpiQualifier2 = config2.getDensityQualifier();
            if (dpiQualifier2 != null) {
                Density value = dpiQualifier2.getValue();
                dpi2 = value != null ? value.getDpiValue() : 160;
            }
            if (dpi1 != (dpi2 = this.mDensitySort.get(dpi2, 100))) return dpi1 - dpi2;
            ScreenOrientation so1 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier1 = config1.getScreenOrientationQualifier();
            if (orientationQualifier1 != null && (so1 = orientationQualifier1.getValue()) == null) {
                so1 = ScreenOrientation.PORTRAIT;
            }
            ScreenOrientation so2 = ScreenOrientation.PORTRAIT;
            ScreenOrientationQualifier orientationQualifier2 = config2.getScreenOrientationQualifier();
            if (orientationQualifier2 != null && (so2 = orientationQualifier2.getValue()) == null) {
                so2 = ScreenOrientation.PORTRAIT;
            }
            if (so1 == ScreenOrientation.PORTRAIT) {
                if (so2 != ScreenOrientation.PORTRAIT) return -1;
                return 0;
            }
            if (so2 != ScreenOrientation.PORTRAIT) return 0;
            return 1;
        }
    }

    private static class TabletConfigComparator
    implements Comparator<ConfigMatch> {
        private final Map<String, Integer> mIdRank;
        private static final String PREFERRED_ID = "Nexus 10";

        private TabletConfigComparator(Map<String, Integer> idRank) {
            this.mIdRank = idRank;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ConfigMatch o1, ConfigMatch o2) {
            ScreenSize ss2;
            FolderConfiguration config2;
            FolderConfiguration config1 = o1 != null ? o1.testConfig : null;
            FolderConfiguration folderConfiguration = config2 = o2 != null ? o2.testConfig : null;
            if (config1 == null) {
                if (config2 != null) return -1;
                return 0;
            }
            if (config2 == null) {
                return 1;
            }
            String n1 = o1.device.getId();
            String n2 = o2.device.getId();
            Integer rank1 = this.mIdRank.get(o1.device.getId());
            Integer rank2 = this.mIdRank.get(o2.device.getId());
            if (rank1 != null) {
                if (rank2 == null) return -1;
                int delta = rank1 - rank2;
                if (delta != 0) {
                    return delta;
                }
            } else if (rank2 != null) {
                return 1;
            }
            if (n1.equals(PREFERRED_ID)) {
                if (!n2.equals(PREFERRED_ID)) return -1;
                return 0;
            }
            if (n2.equals(PREFERRED_ID)) {
                return 1;
            }
            ScreenSizeQualifier size1 = config1.getScreenSizeQualifier();
            ScreenSizeQualifier size2 = config2.getScreenSizeQualifier();
            ScreenSize ss1 = size1 != null ? size1.getValue() : ScreenSize.NORMAL;
            ScreenSize screenSize = ss2 = size2 != null ? size2.getValue() : ScreenSize.NORMAL;
            if (ss1 == ScreenSize.XLARGE) {
                ScreenOrientationQualifier orientation2;
                ScreenOrientation so2;
                if (ss2 != ScreenSize.XLARGE) return -1;
                ScreenOrientationQualifier orientation1 = config1.getScreenOrientationQualifier();
                ScreenOrientation so1 = orientation1.getValue();
                if (so1 == null) {
                    so1 = ScreenOrientation.PORTRAIT;
                }
                if ((so2 = (orientation2 = config2.getScreenOrientationQualifier()).getValue()) == null) {
                    so2 = ScreenOrientation.PORTRAIT;
                }
                if (so1 == ScreenOrientation.LANDSCAPE) {
                    if (so2 != ScreenOrientation.LANDSCAPE) return -1;
                    return 0;
                }
                if (so2 != ScreenOrientation.LANDSCAPE) return 0;
                return 1;
            }
            if (ss2 != ScreenSize.XLARGE) return 0;
            return 1;
        }
    }

    private static class ConfigMatch {
        final FolderConfiguration testConfig;
        final Device device;
        final State state;
        final ConfigBundle bundle;

        public ConfigMatch(@NotNull FolderConfiguration testConfig, @NotNull Device device, @NotNull State state, @NotNull ConfigBundle bundle) {
            if (testConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testConfig", "com/android/tools/idea/configurations/ConfigurationMatcher$ConfigMatch", "<init>"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/configurations/ConfigurationMatcher$ConfigMatch", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/configurations/ConfigurationMatcher$ConfigMatch", "<init>"));
            }
            if (bundle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/android/tools/idea/configurations/ConfigurationMatcher$ConfigMatch", "<init>"));
            }
            this.testConfig = testConfig;
            this.device = device;
            this.state = state;
            this.bundle = bundle;
        }

        public String toString() {
            return this.device.getDisplayName() + " - " + this.state.getName() + " - " + this.bundle;
        }
    }

    private static class ConfigBundle {
        private final FolderConfiguration config = new FolderConfiguration();
        private int localeIndex;
        private int dockModeIndex;
        private int nightModeIndex;

        private ConfigBundle() {
        }

        private ConfigBundle(ConfigBundle bundle) {
            this.config.set(bundle.config);
            this.localeIndex = bundle.localeIndex;
            this.dockModeIndex = bundle.dockModeIndex;
            this.nightModeIndex = bundle.nightModeIndex;
        }

        public String toString() {
            return this.config.getUniqueKey();
        }
    }
}

