/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.FlatAction;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends FlatAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/ThemeMenuAction", "<init>"));
        }
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Theme in Editor");
        presentation.setIcon(AndroidIcons.NeleIcons.Theme);
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ThemeMenuAction", "getThemeLabel"));
            }
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            String string = theme.substring(index + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ThemeMenuAction", "getThemeLabel"));
            }
            return string;
        }
        String string = theme;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ThemeMenuAction", "getThemeLabel"));
        }
        return string;
    }

    public void actionPerformed(AnActionEvent e) {
        String theme;
        ThemeSelectionDialog dialog;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
            configuration.setTheme(theme);
        }
    }
}

