/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.config;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.config.DataBindingConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingConfigurable
implements SearchableConfigurable {
    private JPanel myPanel1;
    private JBRadioButton myGeneratedCodeRadioButton;
    private JBRadioButton myLiveCodeRadioButton;
    private JBLabel restartWarning;
    private DataBindingConfiguration myConfiguration;

    public DataBindingConfigurable() {
        this.$$$setupUI$$$();
        this.myConfiguration = DataBindingConfiguration.getInstance();
        this.updateIU();
    }

    private void updateIU() {
        switch (this.myConfiguration.CODE_NAVIGATION_MODE) {
            case XML: {
                this.myLiveCodeRadioButton.setSelected(true);
                break;
            }
            case CODE: {
                this.myGeneratedCodeRadioButton.setSelected(true);
            }
        }
        this.restartWarning.setForeground((Color)JBColor.RED);
    }

    @NotNull
    public String getId() {
        if ("android.databinding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/config/DataBindingConfigurable", "getId"));
        }
        return "android.databinding";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel1;
    }

    public boolean isModified() {
        boolean modified = this.myConfiguration.CODE_NAVIGATION_MODE != this.getNavigationModeFromUI();
        this.restartWarning.setVisible(modified);
        return modified;
    }

    public void apply() throws ConfigurationException {
        DataBindingConfiguration.CodeNavigationMode ui = this.getNavigationModeFromUI();
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myConfiguration.CODE_NAVIGATION_MODE = ui;
            DataBindingUtil.recalculateEnableInMemoryClassGeneration();
        });
    }

    public void reset() {
        this.updateIU();
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return IdeInfo.getInstance().isAndroidStudio() ? "Data Binding" : "Android Data Binding";
    }

    private DataBindingConfiguration.CodeNavigationMode getNavigationModeFromUI() {
        if (this.myGeneratedCodeRadioButton.isSelected()) {
            return DataBindingConfiguration.CodeNavigationMode.CODE;
        }
        return DataBindingConfiguration.CodeNavigationMode.XML;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        this.myPanel1 = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 3, 1, 0, 3, 3, 3, null, null, null));
        this.myGeneratedCodeRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Reference code generated by the compiler");
        jBRadioButton2.setToolTipText("");
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myLiveCodeRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Reference code generated by Android Studio");
        jBRadioButton.setToolTipText("");
        jPanel2.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setName("");
        jLabel.setText("<html>Binding code is updated instantly as you modify XML files.<br/> You can navigate between the Java code and XML layout. <br/>You cannot debug generated binding code.</html>");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>You can debug the generated code.<br/>\nWhen you modify XML files, binding code is not updated until the application is recompiled.</html>");
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.restartWarning = jBLabel = new JBLabel();
        jBLabel.setText("You may need to restart Android Studio for the changes to take full effect.");
        jPanel2.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel1;
    }
}

