/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenrecord;

import com.android.ddmlib.ScreenRecorderOptions;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenRecorderOptionsDialog
extends DialogWrapper {
    @NonNls
    private static final String SCREENRECORDER_DIMENSIONS_KEY = "ScreenshotRecorder.Options.Dimensions";
    private static final int DEFAULT_BITRATE_MBPS = 4;
    private static int ourBitRateMbps = 4;
    private static int ourWidth;
    private static int ourHeight;
    private JPanel myPanel;
    private JTextField myBitRateTextField;
    private JTextField myWidthTextField;
    private JTextField myHeightTextField;

    public ScreenRecorderOptionsDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/screenrecord/ScreenRecorderOptionsDialog", "<init>"));
        }
        super(project, true);
        this.$$$setupUI$$$();
        if (ourWidth > 0) {
            this.myWidthTextField.setText(Integer.toString(ourWidth));
        }
        if (ourHeight > 0) {
            this.myHeightTextField.setText(Integer.toString(ourHeight));
        }
        if (ourBitRateMbps > 0) {
            this.myBitRateTextField.setText(Integer.toString(ourBitRateMbps));
        }
        this.setTitle("Screen Recorder Options");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return SCREENRECORDER_DIMENSIONS_KEY;
    }

    @Nullable
    protected String getHelpId() {
        return "https://developer.android.com/r/studio-ui/am-video.html";
    }

    protected void doHelpAction() {
        String helpId = this.getHelpId();
        assert (helpId != null);
        BrowserUtil.browse((String)helpId);
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidBundle.message("android.ddms.screenrecord.options.ok.button.text", new Object[0]));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = ScreenRecorderOptionsDialog.validateIntegerMultipleOf(this.myBitRateTextField, 1, "Bit Rate must be an integer.");
        if (info != null) {
            return info;
        }
        info = ScreenRecorderOptionsDialog.validateIntegerMultipleOf(this.myWidthTextField, 16, "Width must be an integer.");
        if (info != null) {
            return info;
        }
        info = ScreenRecorderOptionsDialog.validateIntegerMultipleOf(this.myHeightTextField, 16, "Height must be an integer.");
        if (info != null) {
            return info;
        }
        return super.doValidate();
    }

    @Nullable
    private static ValidationInfo validateIntegerMultipleOf(JTextField textField, int multiple, String errorMessage) {
        int x;
        String s = ScreenRecorderOptionsDialog.getText(textField);
        if (s.isEmpty()) {
            return null;
        }
        try {
            x = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return new ValidationInfo(errorMessage, (JComponent)textField);
        }
        return x % multiple > 0 ? new ValidationInfo("Must be a multiple of " + multiple, (JComponent)textField) : null;
    }

    protected void doOKAction() {
        ourBitRateMbps = ScreenRecorderOptionsDialog.getIntegerValue(this.myBitRateTextField);
        ourHeight = ScreenRecorderOptionsDialog.getIntegerValue(this.myHeightTextField);
        ourWidth = ScreenRecorderOptionsDialog.getIntegerValue(this.myWidthTextField);
        super.doOKAction();
    }

    private static int getIntegerValue(JTextField textField) {
        String s = ScreenRecorderOptionsDialog.getText(textField);
        return s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    private static String getText(JTextField textField) {
        Document doc = textField.getDocument();
        try {
            return doc.getText(0, doc.getLength()).trim();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public ScreenRecorderOptions getOptions() {
        return new ScreenRecorderOptions.Builder().setBitRate(ourBitRateMbps).setSize(ourWidth, ourHeight).build();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Bit Rate (Mbps):");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBitRateTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Resolution (width x height, in px):");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myWidthTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHeightTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.info"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

