/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class StringResourceParser {
    public static StringResourceData parse(final @NotNull AndroidFacet facet, final @NotNull LocalResourceRepository repository) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringResourceParser", "parse"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/editors/strings/StringResourceParser", "parse"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringResourceParser.parseUnderReadLock(facet, repository);
        }
        return (StringResourceData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<StringResourceData>(){

            public StringResourceData compute() {
                return StringResourceParser.parseUnderReadLock(facet, repository);
            }
        });
    }

    @NotNull
    private static StringResourceData parseUnderReadLock(AndroidFacet facet, LocalResourceRepository repository) {
        ArrayList keys = Lists.newArrayList((Iterable)repository.getItemsOfType(ResourceType.STRING));
        Collections.sort(keys);
        HashMap<String, StringResource> keyToResourceMap = new HashMap<String, StringResource>();
        Project project = facet.getModule().getProject();
        for (String key : keys) {
            List items = repository.getResourceItem(ResourceType.STRING, key);
            if (items == null) continue;
            StringResource stringResource = new StringResource(key);
            for (ResourceItem item : items) {
                LocaleQualifier qualifier;
                XmlTag tag = LocalResourceRepository.getItemTag(project, item);
                if (tag != null && "false".equals(tag.getAttributeValue("translatable"))) {
                    stringResource.setTranslatable(false);
                }
                String itemStringRepresentation = StringResourceParser.resourceToString(project, item);
                FolderConfiguration config = item.getConfiguration();
                LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
                if (qualifier == null) {
                    stringResource.setDefaultValue(item, itemStringRepresentation);
                    continue;
                }
                Locale locale = Locale.create(qualifier);
                stringResource.putTranslation(locale, item, itemStringRepresentation);
            }
            keyToResourceMap.put(key, stringResource);
        }
        StringResourceData stringResourceData = new StringResourceData(facet, keyToResourceMap);
        if (stringResourceData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceParser", "parseUnderReadLock"));
        }
        return stringResourceData;
    }

    @NotNull
    private static String resourceToString(@NotNull Project project, @NotNull ResourceItem item) {
        String string;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceParser", "resourceToString"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/strings/StringResourceParser", "resourceToString"));
        }
        XmlTag tag = LocalResourceRepository.getItemTag(project, item);
        if (tag == null) {
            ResourceValue value = item.getResourceValue(false);
            if (value == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceParser", "resourceToString"));
                }
                return "";
            }
            string = value.getRawXmlValue();
        } else {
            string = tag.getValue().getText();
        }
        String string2 = Strings.nullToEmpty((String)ValueXmlHelper.unescapeResourceString((String)string, (boolean)false, (boolean)false));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceParser", "resourceToString"));
        }
        return string2;
    }
}

