/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.actions;

import com.android.tools.idea.experimental.actions.PermissionUsageQuickFixRunnable;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionUsageQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public PermissionUsageQuickFix(@Nullable PsiElement element) {
        super(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "invoke"));
        }
        PermissionUsageQuickFix.openFile(project, file);
        OpenFileDescriptor fileDesc = new OpenFileDescriptor(project, file.getVirtualFile(), startElement.getTextOffset());
        editor = FileEditorManager.getInstance((Project)project).openTextEditor(fileDesc, true);
        assert (editor != null);
        int startOffset = startElement.getTextOffset();
        int endOffset = endElement.getTextOffset() + endElement.getTextLength();
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        PermissionUsageQuickFixRunnable job = new PermissionUsageQuickFixRunnable(project, editor);
        this.execRunnable(job, "Permission Fix");
    }

    private void execRunnable(@NotNull Runnable job, String title) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "execRunnable"));
        }
        ApplicationManager.getApplication().runWriteAction(job);
    }

    public static void openFile(Project project, PsiFile file) {
        String path = file.getVirtualFile().getCanonicalPath();
        assert (path != null);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        VirtualFile virtFile = LocalFileSystem.getInstance().findFileByPath(path);
        assert (virtFile != null);
        manager.openFile(virtFile, true, true);
    }

    @NotNull
    public String getText() {
        if ("Insert guards for permission usage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "getText"));
        }
        return "Insert guards for permission usage";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Insert permission usage getFamilyName()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/actions/PermissionUsageQuickFix", "getFamilyName"));
        }
        return "Insert permission usage getFamilyName()";
    }
}

