/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.OptionalCompilationStep;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuilder
implements BeforeRunBuilder {
    private static final Logger LOG = Logger.getInstance(InstantRunBuilder.class);
    @Nullable
    private final IDevice myDevice;
    private final InstantRunContext myInstantRunContext;
    private final AndroidRunConfigContext myRunContext;
    private final InstantRunTasksProvider myTasksProvider;
    private final InstalledApkCache myInstalledApkCache;
    private final InstantRunClientDelegate myInstantRunClientDelegate;
    private final boolean myFlightRecorderEnabled;

    public InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider) {
        if (instantRunContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runConfigContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (tasksProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksProvider", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        this(device, instantRunContext, runConfigContext, tasksProvider, InstantRunSettings.isRecorderEnabled(), (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), new InstantRunClientDelegate(){});
    }

    InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider, boolean enableFlightRecorder, @NotNull InstalledApkCache installedApkCache, @NotNull InstantRunClientDelegate delegate) {
        if (instantRunContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (runConfigContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigContext", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (tasksProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksProvider", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (installedApkCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedApkCache", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/fd/InstantRunBuilder", "<init>"));
        }
        this.myDevice = device;
        this.myInstantRunContext = instantRunContext;
        this.myRunContext = runConfigContext;
        this.myTasksProvider = tasksProvider;
        this.myFlightRecorderEnabled = enableFlightRecorder;
        this.myInstalledApkCache = installedApkCache;
        this.myInstantRunClientDelegate = delegate;
    }

    @Override
    public boolean build(@NotNull GradleTaskRunner taskRunner, @NotNull List<String> commandLineArguments) throws InterruptedException, InvocationTargetException {
        if (taskRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskRunner", "com/android/tools/idea/fd/InstantRunBuilder", "build"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/fd/InstantRunBuilder", "build"));
        }
        BuildSelection buildSelection = this.getBuildSelection();
        this.myInstantRunContext.setBuildSelection(buildSelection);
        if (buildSelection.getBuildMode() != BuildMode.HOT) {
            LOG.info(buildSelection.why.toString());
        }
        ArrayList<String> args = new ArrayList<String>(commandLineArguments);
        args.addAll(this.myInstantRunContext.getCustomBuildArguments());
        args.addAll(InstantRunBuilder.getInstantRunArguments(buildSelection.getBuildMode()));
        args.addAll(this.getFlightRecorderArguments());
        LinkedList<String> tasks = new LinkedList<String>();
        if (buildSelection.getBuildMode() == BuildMode.CLEAN) {
            tasks.addAll(this.myTasksProvider.getCleanAndGenerateSourcesTasks());
        }
        tasks.addAll(this.myTasksProvider.getFullBuildTasks());
        return taskRunner.run(tasks, null, args);
    }

    @NotNull
    private BuildSelection getBuildSelection() {
        BuildCause buildCause = this.computeBuildCause(this.myDevice);
        boolean brokenForSecondaryUser = buildCause != BuildCause.INCREMENTAL_BUILD && InstantRunBuilder.hasMultiUser(this.myDevice);
        BuildSelection buildSelection = new BuildSelection(buildCause, brokenForSecondaryUser);
        if (buildSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getBuildSelection"));
        }
        return buildSelection;
    }

    private static boolean hasMultiUser(@Nullable IDevice device) {
        return MultiUserUtils.hasMultipleUsers(device, 200L, TimeUnit.MILLISECONDS, false);
    }

    @NotNull
    private BuildCause computeBuildCause(@Nullable IDevice device) {
        if (device == null) {
            BuildCause buildCause = BuildCause.NO_DEVICE;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (this.myRunContext.isCleanRerun()) {
            BuildCause buildCause = BuildCause.USER_REQUESTED_CLEAN_BUILD;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        int defaultUserId = 0;
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), defaultUserId)) {
            BuildCause buildCause = BuildCause.APP_NOT_INSTALLED;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (!this.buildTimestampsMatch(device, defaultUserId)) {
            BuildCause buildCause = BuildCause.MISMATCHING_TIMESTAMPS;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        AndroidVersion deviceVersion = device.getVersion();
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(deviceVersion)) {
            BuildCause buildCause = BuildCause.API_TOO_LOW_FOR_INSTANT_RUN;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (!InstantRunManager.hasLocalCacheOfDeviceData(device, this.myInstantRunContext)) {
            BuildCause buildCause = BuildCause.FIRST_INSTALLATION_TO_DEVICE;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (ApplicationManager.getApplication() != null) {
            GradleBuildInvoker.saveAllFilesSafely();
        }
        if (this.manifestResourceChanged(device)) {
            BuildCause buildCause = BuildCause.MANIFEST_RESOURCE_CHANGED;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (!this.isAppRunning(device) && !deviceVersion.isGreaterOrEqualThan(21)) {
            BuildCause buildCause = BuildCause.FREEZE_SWAP_REQUIRES_API21;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (this.myRunContext.isForceColdswap()) {
            BuildCause buildCause = this.myRunContext.couldHaveInvokedHotswap() ? BuildCause.USER_CHOSE_TO_COLDSWAP : BuildCause.USER_REQUESTED_COLDSWAP;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (!this.isAppRunning(device)) {
            BuildCause buildCause = BuildCause.APP_NOT_RUNNING;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV) || StringUtil.notNullize((String)device.getProperty("ro.product.model")).contains("sdk_google_atv_")) {
            BuildCause buildCause = BuildCause.ANDROID_TV_UNSUPPORTED;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        if (this.myInstantRunContext.usesMultipleProcesses()) {
            BuildCause buildCause = BuildCause.APP_USES_MULTIPLE_PROCESSES;
            if (buildCause == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
            }
            return buildCause;
        }
        BuildCause buildCause = BuildCause.INCREMENTAL_BUILD;
        if (buildCause == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "computeBuildCause"));
        }
        return buildCause;
    }

    private boolean isAppRunning(@NotNull IDevice device) {
        boolean isAppRunning;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "isAppRunning"));
        }
        try {
            isAppRunning = this.myInstantRunClientDelegate.isAppInForeground(device, this.myInstantRunContext);
        }
        catch (IOException e) {
            InstantRunManager.LOG.warn("IOException while attempting to determine if app is in foreground, assuming app not alive");
            isAppRunning = false;
            InstantRunManager.LOG.warn("Force killing app");
            try {
                device.executeShellCommand("am force-stop " + this.myInstantRunContext.getApplicationId(), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAppRunning && this.myRunContext.isSameExecutorAsPreviousSession();
    }

    private static List<String> getInstantRunArguments(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/fd/InstantRunBuilder", "getInstantRunArguments"));
        }
        StringBuilder sb = new StringBuilder(50);
        sb.append("-P");
        sb.append("android.optional.compilation");
        sb.append("=");
        sb.append(OptionalCompilationStep.INSTANT_DEV.name());
        switch (buildMode) {
            case HOT: {
                break;
            }
            case COLD: {
                sb.append(",").append(OptionalCompilationStep.RESTART_ONLY.name());
                break;
            }
            case FULL: 
            case CLEAN: {
                sb.append(",").append(OptionalCompilationStep.FULL_APK.name());
            }
        }
        String compilationSteps = sb.toString();
        String coldSwapMode = AndroidGradleSettings.createProjectProperty((String)"android.injected.coldswap.mode", (String)"MULTIAPK");
        return ImmutableList.of((Object)compilationSteps, (Object)coldSwapMode);
    }

    @NotNull
    private List<String> getFlightRecorderArguments() {
        ImmutableList immutableList = this.myFlightRecorderEnabled ? ImmutableList.of((Object)"--info", (Object)"--full-stacktrace") : ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunBuilder", "getFlightRecorderArguments"));
        }
        return immutableList;
    }

    private boolean buildTimestampsMatch(@NotNull IDevice device, @Nullable Integer userId) {
        String localTimestamp;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "buildTimestampsMatch"));
        }
        InstantRunBuildInfo instantRunBuildInfo = this.myInstantRunContext.getInstantRunBuildInfo();
        String string = localTimestamp = instantRunBuildInfo == null ? null : instantRunBuildInfo.getTimeStamp();
        if (StringUtil.isEmpty((String)localTimestamp)) {
            InstantRunManager.LOG.info("Local build timestamp is empty!");
            return false;
        }
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), userId)) {
            return false;
        }
        String deviceBuildTimestamp = this.myInstantRunClientDelegate.getDeviceBuildTimestamp(device, this.myInstantRunContext);
        InstantRunManager.LOG.info(String.format("Build timestamps: Local: %1$s, Device: %2$s", localTimestamp, deviceBuildTimestamp));
        return localTimestamp.equals(deviceBuildTimestamp);
    }

    private boolean isAppInstalledForUser(@NotNull IDevice device, @NotNull String pkgName, @Nullable Integer userId) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "isAppInstalledForUser"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/fd/InstantRunBuilder", "isAppInstalledForUser"));
        }
        InstalledApkCache.InstallState installState = this.myInstalledApkCache.getInstallState(device, pkgName);
        if (installState == null) {
            InstantRunManager.LOG.info("Package " + pkgName + " was not detected on the device.");
            return false;
        }
        if (userId != null && !installState.users.isEmpty() && !installState.users.contains(userId)) {
            LOG.info("Package " + pkgName + " was not installed for default user.");
            return false;
        }
        return true;
    }

    public boolean manifestResourceChanged(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder", "manifestResourceChanged"));
        }
        InstalledPatchCache cache = this.myInstantRunContext.getInstalledPatchCache();
        HashCode currentHash = this.myInstantRunContext.getManifestResourcesHash();
        HashCode installedHash = cache.getInstalledManifestResourcesHash(device, this.myInstantRunContext.getApplicationId());
        return installedHash != null && !installedHash.equals((Object)currentHash);
    }

    static interface InstantRunClientDelegate {
        default public String getDeviceBuildTimestamp(@NotNull IDevice device, @NotNull InstantRunContext instantRunContext) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "getDeviceBuildTimestamp"));
            }
            if (instantRunContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "getDeviceBuildTimestamp"));
            }
            return InstantRunClient.getDeviceBuildTimestamp((IDevice)device, (String)instantRunContext.getApplicationId(), (ILogger)InstantRunManager.ILOGGER);
        }

        default public boolean isAppInForeground(@NotNull IDevice device, @NotNull InstantRunContext context) throws IOException {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "isAppInForeground"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunBuilder$InstantRunClientDelegate", "isAppInForeground"));
            }
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            try {
                return instantRunClient != null && instantRunClient.getAppState(device) == AppState.FOREGROUND;
            }
            catch (IOException e) {
                Client client = device.getClient(context.getApplicationId());
                if (client == null) {
                    InstantRunManager.LOG.info("Application not running");
                    return false;
                }
                throw e;
            }
        }
    }
}

