/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class LogcatRecorder {
    private static final int BUFSIZE = 8192;
    private final Object LOCK;
    private final EvictingQueue<String> myLogs;
    private final AndroidLogcatService myLogcatService;
    private AtomicReference<IDevice> myDeviceRef;
    private AndroidLogcatService.LogcatListener myLogListener;

    public LogcatRecorder(@NotNull AndroidLogcatService logcatService) {
        if (logcatService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logcatService", "com/android/tools/idea/fd/LogcatRecorder", "<init>"));
        }
        this.LOCK = new Object();
        this.myLogs = EvictingQueue.create((int)8192);
        this.myDeviceRef = new AtomicReference();
        this.myLogcatService = logcatService;
        this.myLogListener = new MyLogLineListener();
    }

    public void startMonitoring(@NotNull IDevice device, @NotNull LocalDateTime buildTimeStamp) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/LogcatRecorder", "startMonitoring"));
        }
        if (buildTimeStamp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTimeStamp", "com/android/tools/idea/fd/LogcatRecorder", "startMonitoring"));
        }
        IDevice old = this.myDeviceRef.getAndSet(device);
        if (old != device) {
            if (old != null) {
                this.myLogcatService.removeListener(old, this.myLogListener);
            }
            this.myLogcatService.addListener(device, this.myLogListener);
            LogcatRecorder.enableInstantRunLog(device);
        }
        this.addLog("------------Launch on " + device.getName() + " @ " + buildTimeStamp.toString());
    }

    private static void enableInstantRunLog(IDevice device) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                device.executeShellCommand("setprop log.tag.InstantRun VERBOSE", (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLogs() {
        Object object = this.LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.myLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLog(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/fd/LogcatRecorder", "addLog"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myLogs.add((Object)s);
        }
    }

    private class MyLogLineListener
    implements AndroidLogcatService.LogcatListener {
        private MyLogLineListener() {
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/fd/LogcatRecorder$MyLogLineListener", "onLogLineReceived"));
            }
            if ("InstantRun".equals(line.getTag())) {
                LogcatRecorder.this.addLog(line.toString());
            }
        }
    }
}

