/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidStudioGradleAction
extends AnAction {
    protected final boolean myAndroidStudio;

    protected AndroidStudioGradleAction(@Nullable String text) {
        this(text, IdeInfo.getInstance().isAndroidStudio());
    }

    @VisibleForTesting
    AndroidStudioGradleAction(@Nullable String text, boolean androidStudio) {
        this(text, null, null, androidStudio);
    }

    protected AndroidStudioGradleAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        this(text, description, icon, IdeInfo.getInstance().isAndroidStudio());
    }

    private AndroidStudioGradleAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, boolean androidStudio) {
        super(text, description, icon);
        this.myAndroidStudio = androidStudio;
    }

    public final void update(AnActionEvent e) {
        if (!this.isGradleProjectInAndroidStudio(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        Project project = e.getProject();
        assert (project != null);
        this.doUpdate(e, project);
    }

    protected abstract void doUpdate(@NotNull AnActionEvent var1, @NotNull Project var2);

    public final void actionPerformed(AnActionEvent e) {
        if (!this.isGradleProjectInAndroidStudio(e)) {
            return;
        }
        Project project = e.getProject();
        assert (project != null);
        this.doPerform(e, project);
    }

    protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Project var2);

    private boolean isGradleProjectInAndroidStudio(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AndroidStudioGradleAction", "isGradleProjectInAndroidStudio"));
        }
        if (this.myAndroidStudio) {
            Project project = e.getProject();
            return project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle();
        }
        return false;
    }
}

