/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.base.Objects;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SigningConfigModel
extends GradleDslBlockModel {
    @NonNls
    private static final String SYSTEM_GETENV = "System.getenv";
    @NonNls
    private static final String SYSTEM_CONSOLE_READ_LINE = "System.console().readLine";
    @NonNls
    private static final String STORE_FILE = "storeFile";
    @NonNls
    private static final String STORE_PASSWORD = "storePassword";
    @NonNls
    private static final String STORE_TYPE = "storeType";
    @NonNls
    private static final String KEY_ALIAS = "keyAlias";
    @NonNls
    private static final String KEY_PASSWORD = "keyPassword";

    public SigningConfigModel(@NotNull SigningConfigDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "<init>"));
        }
        super(dslElement);
        this.myDslElement = dslElement;
    }

    @NotNull
    public String name() {
        String string = this.myDslElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "name"));
        }
        return string;
    }

    @NotNull
    public GradleNullableValue<String> storeFile() {
        GradleDslExpression expression = this.getStoreFileExpression();
        if (expression == null) {
            GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(this.myDslElement, null);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", STORE_FILE));
            }
            return gradleNullableValue;
        }
        GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(expression, expression.getValue(String.class));
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", STORE_FILE));
        }
        return gradleNullableValue;
    }

    public SigningConfigModel setStoreFile(@NotNull String storeFile) {
        if (storeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORE_FILE, "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setStoreFile"));
        }
        if (this.myDslElement.getPropertyElement(STORE_FILE) == null) {
            GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)this.myDslElement, "file", STORE_FILE);
            GradleDslLiteral literal = new GradleDslLiteral(methodCall, "");
            literal.setValue(storeFile);
            methodCall.addNewArgument(literal);
            this.myDslElement.setNewElement(STORE_FILE, methodCall);
        } else {
            GradleDslExpression expression = this.getStoreFileExpression();
            if (expression != null) {
                expression.setValue(storeFile);
            }
        }
        return this;
    }

    public SigningConfigModel removeStoreFile() {
        this.myDslElement.removeProperty(STORE_FILE);
        return this;
    }

    @Nullable
    private GradleDslExpression getStoreFileExpression() {
        GradleDslMethodCall methodCall = this.myDslElement.getPropertyElement(STORE_FILE, GradleDslMethodCall.class);
        if (methodCall == null || methodCall.getArguments().size() == 0) {
            return null;
        }
        GradleDslElement argument = methodCall.getArguments().get(0);
        if (argument instanceof GradleDslExpression) {
            return (GradleDslExpression)argument;
        }
        return null;
    }

    @NotNull
    public GradleNullableValue<SigningConfigPassword> storePassword() {
        GradleNullableValue<SigningConfigPassword> gradleNullableValue = this.getPasswordValue(STORE_PASSWORD);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", STORE_PASSWORD));
        }
        return gradleNullableValue;
    }

    public SigningConfigModel setStorePassword(@NotNull SigningConfigPassword.Type type, @NotNull String storePassword) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setStorePassword"));
        }
        if (storePassword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORE_PASSWORD, "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setStorePassword"));
        }
        this.setPasswordValue(STORE_PASSWORD, type, storePassword);
        return this;
    }

    public SigningConfigModel removeStorePassword() {
        this.myDslElement.removeProperty(STORE_PASSWORD);
        return this;
    }

    @NotNull
    public GradleNullableValue<String> storeType() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(STORE_TYPE, String.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", STORE_TYPE));
        }
        return gradleNullableValue;
    }

    public SigningConfigModel setStoreType(@NotNull String storeType) {
        if (storeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", STORE_TYPE, "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setStoreType"));
        }
        this.myDslElement.setNewLiteral(STORE_TYPE, storeType);
        return this;
    }

    public SigningConfigModel removeStoreType() {
        this.myDslElement.removeProperty(STORE_TYPE);
        return this;
    }

    @NotNull
    public GradleNullableValue<String> keyAlias() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(KEY_ALIAS, String.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", KEY_ALIAS));
        }
        return gradleNullableValue;
    }

    public SigningConfigModel setKeyAlias(@NotNull String keyAlias) {
        if (keyAlias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY_ALIAS, "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setKeyAlias"));
        }
        this.myDslElement.setNewLiteral(KEY_ALIAS, keyAlias);
        return this;
    }

    public SigningConfigModel removeKeyAlias() {
        this.myDslElement.removeProperty(KEY_ALIAS);
        return this;
    }

    @NotNull
    public GradleNullableValue<SigningConfigPassword> keyPassword() {
        GradleNullableValue<SigningConfigPassword> gradleNullableValue = this.getPasswordValue(KEY_PASSWORD);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", KEY_PASSWORD));
        }
        return gradleNullableValue;
    }

    public SigningConfigModel setKeyPassword(@NotNull SigningConfigPassword.Type type, @NotNull String keyPassword) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setKeyPassword"));
        }
        if (keyPassword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY_PASSWORD, "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setKeyPassword"));
        }
        this.setPasswordValue(KEY_PASSWORD, type, keyPassword);
        return this;
    }

    public SigningConfigModel removeKeyPassword() {
        this.myDslElement.removeProperty(KEY_PASSWORD);
        return this;
    }

    @NotNull
    private GradleNullableValue<SigningConfigPassword> getPasswordValue(@NotNull String property) {
        SigningConfigPassword.Type passwordType;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "getPasswordValue"));
        }
        GradleDslExpression passwordElement = this.getPasswordElement(property);
        if (passwordElement == null) {
            GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(this.myDslElement, null);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "getPasswordValue"));
            }
            return gradleNullableValue;
        }
        switch (passwordElement.getName()) {
            case "System.getenv": {
                passwordType = SigningConfigPassword.Type.ENVIRONMENT_VARIABLE;
                break;
            }
            case "System.console().readLine": {
                passwordType = SigningConfigPassword.Type.CONSOLE_READ;
                break;
            }
            default: {
                passwordType = SigningConfigPassword.Type.PLAIN_TEXT;
            }
        }
        String passwordText = passwordElement.getValue(String.class);
        if (passwordText != null) {
            GradleNullableValue<SigningConfigPassword> gradleNullableValue = new GradleNullableValue<SigningConfigPassword>(passwordElement, new SigningConfigPassword(passwordType, passwordText));
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "getPasswordValue"));
            }
            return gradleNullableValue;
        }
        GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(passwordElement, null);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "getPasswordValue"));
        }
        return gradleNullableValue;
    }

    @Nullable
    private GradleDslExpression getPasswordElement(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "getPasswordElement"));
        }
        GradleDslExpression passwordElement = this.myDslElement.getPropertyElement(property, GradleDslExpression.class);
        if (passwordElement == null) {
            return null;
        }
        if (passwordElement instanceof GradleDslMethodCall) {
            GradleDslElement argumentElement;
            List<GradleDslElement> arguments = ((GradleDslMethodCall)passwordElement).getArguments();
            if (!arguments.isEmpty() && (argumentElement = arguments.get(0)) instanceof GradleDslExpression) {
                return (GradleDslExpression)argumentElement;
            }
        } else {
            return passwordElement;
        }
        return null;
    }

    private void setPasswordValue(@NotNull String property, @NotNull SigningConfigPassword.Type type, @NotNull String text) {
        GradleDslExpression element;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setPasswordValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setPasswordValue"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel", "setPasswordValue"));
        }
        if (type == SigningConfigPassword.Type.PLAIN_TEXT) {
            this.myDslElement.setNewLiteral(property, text);
            return;
        }
        GradleNullableValue<SigningConfigPassword> passwordValue = this.getPasswordValue(property);
        SigningConfigPassword password = (SigningConfigPassword)passwordValue.value();
        if (password != null && password.getType() == type && (element = this.getPasswordElement(property)) != null) {
            element.setValue(text);
            return;
        }
        GradleDslMethodCall methodCall = null;
        if (type == SigningConfigPassword.Type.ENVIRONMENT_VARIABLE) {
            methodCall = new GradleDslMethodCall((GradleDslElement)this.myDslElement, SYSTEM_GETENV, property);
        } else if (type == SigningConfigPassword.Type.CONSOLE_READ) {
            methodCall = new GradleDslMethodCall((GradleDslElement)this.myDslElement, SYSTEM_CONSOLE_READ_LINE, property);
        }
        if (methodCall != null) {
            GradleDslLiteral argumentElement = new GradleDslLiteral(methodCall, methodCall.getName());
            argumentElement.setValue(text);
            methodCall.addNewArgument(argumentElement);
            this.myDslElement.setNewElement(property, methodCall);
        }
    }

    public static final class SigningConfigPassword {
        @NotNull
        private final Type myType;
        @NotNull
        private final String myPasswordText;

        public SigningConfigPassword(@NotNull Type type, @NotNull String passwordText) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel$SigningConfigPassword", "<init>"));
            }
            if (passwordText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordText", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel$SigningConfigPassword", "<init>"));
            }
            this.myType = type;
            this.myPasswordText = passwordText;
        }

        @NotNull
        public Type getType() {
            Type type = this.myType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel$SigningConfigPassword", "getType"));
            }
            return type;
        }

        @NotNull
        public String getPasswordText() {
            String string = this.myPasswordText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/SigningConfigModel$SigningConfigPassword", "getPasswordText"));
            }
            return string;
        }

        public String toString() {
            return String.format("Type: %1$s, Text: %2$s", new Object[]{this.myType, this.myPasswordText});
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myType, this.myPasswordText});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SigningConfigPassword)) {
                return false;
            }
            SigningConfigPassword other = (SigningConfigPassword)o;
            return this.myType.equals((Object)other.myType) && this.myPasswordText.equals(other.myPasswordText);
        }

        public static enum Type {
            PLAIN_TEXT,
            ENVIRONMENT_VARIABLE,
            CONSOLE_READ;

        }
    }
}

