/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.ExcludedDependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependencyConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DependencyConfigurationModel {
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NonNls
    private static final String FORCE = "force";
    @NonNls
    private static final String TRANSITIVE = "transitive";
    @NotNull
    DependencyConfigurationDslElement myConfigurationElement;

    public DependencyConfigurationModel(@NotNull DependencyConfigurationDslElement configurationElement) {
        if (configurationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationElement", "com/android/tools/idea/gradle/dsl/model/dependencies/DependencyConfigurationModel", "<init>"));
        }
        this.myConfigurationElement = configurationElement;
    }

    @NotNull
    public List<ExcludedDependencyModel> excludes() {
        GradleDslElementList elementList = this.myConfigurationElement.getPropertyElement(EXCLUDE, GradleDslElementList.class);
        if (elementList == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependencyConfigurationModel", "excludes"));
            }
            return immutableList;
        }
        ArrayList<ExcludedDependencyModel> excludedDependencies = new ArrayList<ExcludedDependencyModel>();
        for (GradleDslExpressionMap excludeElement : elementList.getElements(GradleDslExpressionMap.class)) {
            excludedDependencies.add(new ExcludedDependencyModel(excludeElement));
        }
        ArrayList<ExcludedDependencyModel> arrayList = excludedDependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependencyConfigurationModel", "excludes"));
        }
        return arrayList;
    }

    @NotNull
    public GradleNullableValue<Boolean> force() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myConfigurationElement.getLiteralProperty(FORCE, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependencyConfigurationModel", FORCE));
        }
        return gradleNullableValue;
    }

    @NotNull
    public GradleNullableValue<Boolean> transitive() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myConfigurationElement.getLiteralProperty(TRANSITIVE, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependencyConfigurationModel", TRANSITIVE));
        }
        return gradleNullableValue;
    }
}

