/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.settings;

import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslNewExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPropertiesDslElement
extends GradlePropertiesDslElement {
    @NonNls
    private static final String PROJECT_DIR = "projectDir";
    @NonNls
    private static final String BUILD_FILE_NAME = "buildFileName";

    public ProjectPropertiesDslElement(@Nullable GradleDslElement parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/settings/ProjectPropertiesDslElement", "<init>"));
        }
        super(parent, null, name);
    }

    @Nullable
    public File projectDir() {
        GradleDslNewExpression projectDir = this.getPropertyElement(PROJECT_DIR, GradleDslNewExpression.class);
        if (projectDir != null) {
            return projectDir.getValue(File.class);
        }
        return null;
    }

    @NotNull
    public GradleNullableValue<String> buildFileName() {
        GradleNullableValue<String> gradleNullableValue = this.getLiteralProperty(BUILD_FILE_NAME, String.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/settings/ProjectPropertiesDslElement", BUILD_FILE_NAME));
        }
        return gradleNullableValue;
    }

    @Nullable
    public static String getStandardProjectKey(@NotNull String projectReference) {
        if (projectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectReference", "com/android/tools/idea/gradle/dsl/parser/settings/ProjectPropertiesDslElement", "getStandardProjectKey"));
        }
        String standardForm = projectReference.replaceAll("\\s", "").replace("\"", "'");
        if (standardForm.startsWith("project(':") && standardForm.endsWith("')")) {
            return standardForm;
        }
        return null;
    }
}

