/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");

    NewProjectSetup() {
    }

    @NotNull
    Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "createProject"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "createProject"));
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        Project project = newProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "createProject"));
        }
        return project;
    }

    @NotNull
    Project openProject(@NotNull String projectPath) throws IOException {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "openProject"));
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project newProject = projectManager.loadProject(projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to open project at '" + projectPath + "'");
        }
        Project project = newProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "openProject"));
        }
        return project;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "prepareProjectForImport"));
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "lambda$prepareProjectForImport$1"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                LanguageLevelProjectExtension extension;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/importing/NewProjectSetup", "lambda$null$0"));
                }
                if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                    extension.setLanguageLevel(languageLevel);
                }
                File compilerOutputDirPath = new File(Projects.getBaseDirPath(project), FileUtil.join((String[])new String[]{"build", "classes"}));
                String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDirPath);
                CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
                assert (compilerProjectExt != null);
                compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
                ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
            });
        }, null, null);
    }
}

