/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

class ModuleFactory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;

    ModuleFactory(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "<init>"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "<init>"));
        }
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
    }

    @NotNull
    Module createModule(@NotNull IdeaModule ideaModule, @NotNull SyncAction.ModuleModels moduleModels) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "createModule"));
        }
        if (moduleModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModels", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "createModule"));
        }
        File imlFilePath = this.getModuleImlFilePath(ideaModule, moduleModels);
        Module newModule = this.myModelsProvider.newModule(imlFilePath.getPath(), StdModuleTypes.JAVA.getId());
        ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(newModule);
        rootModel.inheritSdk();
        DependencyRemover dependencyRemover = new DependencyRemover(rootModel);
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
        ModifiableFacetModel facetModel = this.myModelsProvider.getModifiableFacetModel(newModule);
        for (Facet facet : facetModel.getAllFacets()) {
            facetModel.removeFacet(facet);
        }
        Module module = newModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "createModule"));
        }
        return module;
    }

    @NotNull
    private File getModuleImlFilePath(@NotNull IdeaModule ideaModule, @NotNull SyncAction.ModuleModels moduleModels) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModuleImlFilePath"));
        }
        if (moduleModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModels", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModuleImlFilePath"));
        }
        String modulePath = this.getModulePath(ideaModule, moduleModels);
        String imlFileName = ideaModule.getName() + ".iml";
        File file = new File(modulePath, imlFileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModuleImlFilePath"));
        }
        return file;
    }

    @NotNull
    private String getModulePath(@NotNull IdeaModule ideaModule, @NotNull SyncAction.ModuleModels moduleModels) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModulePath"));
        }
        if (moduleModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModels", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModulePath"));
        }
        GradleProject gradleProject = ideaModule.getGradleProject();
        GradleBuild gradleBuild = moduleModels.findModel(GradleBuild.class);
        if (gradleBuild != null) {
            File moduleDirPath = GradleProjectResolverUtil.getModuleDirPath((GradleBuild)gradleBuild, (String)gradleProject.getPath());
            if (moduleDirPath == null) {
                throw new IllegalStateException(String.format("Unable to find root directory for module '%1$s'", ideaModule.getName()));
            }
            String string = FileUtil.toCanonicalPath((String)moduleDirPath.getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModulePath"));
            }
            return string;
        }
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        String string = FileUtil.toSystemDependentName((String)GradleUtil.getConfigPath((GradleProject)gradleProject, (String)projectPath));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ModuleFactory", "getModulePath"));
        }
        return string;
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        @NotNull
        private final ModifiableRootModel myRootModel;

        DependencyRemover(@NotNull ModifiableRootModel rootModel) {
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/android/tools/idea/gradle/project/sync/ModuleFactory$DependencyRemover", "<init>"));
            }
            this.myRootModel = rootModel;
        }

        public Object visitModuleOrderEntry(ModuleOrderEntry orderEntry, Object value) {
            return this.remove((OrderEntry)orderEntry, value);
        }

        public Object visitLibraryOrderEntry(LibraryOrderEntry orderEntry, Object value) {
            return this.remove((OrderEntry)orderEntry, value);
        }

        private Object remove(OrderEntry orderEntry, Object value) {
            this.myRootModel.removeOrderEntry(orderEntry);
            return value;
        }
    }
}

