/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Key;
import java.io.File;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;

public class SimulatedSyncErrors {
    private static Key<ExternalSystemException> SIMULATED_ERROR_KEY = Key.create((String)"com.android.tools.idea.gradle.sync.simulated.errors");

    private SimulatedSyncErrors() {
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        SimulatedSyncErrors.verifyIsTestMode();
        ExternalSystemException exception = new ExternalSystemException(errorMessage);
        SimulatedSyncErrors.store(exception);
    }

    public static void registerSyncErrorToSimulate(@NotNull Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        SimulatedSyncErrors.verifyIsTestMode();
        ExternalSystemException exception = new ExternalSystemException(cause.getMessage());
        exception.initCause(cause);
        SimulatedSyncErrors.store(exception);
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage, @NotNull File errorFile) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        if (errorFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorFile", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        SimulatedSyncErrors.verifyIsTestMode();
        LocationAwareExternalSystemException exception = new LocationAwareExternalSystemException(errorMessage, errorFile.getPath(), new String[0]);
        SimulatedSyncErrors.store((ExternalSystemException)exception);
    }

    public static void registerSyncErrorToSimulate(@NotNull Throwable cause, @NotNull File errorFile) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        if (errorFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorFile", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "registerSyncErrorToSimulate"));
        }
        SimulatedSyncErrors.verifyIsTestMode();
        LocationAwareExternalSystemException exception = new LocationAwareExternalSystemException(cause.getMessage(), errorFile.getPath(), new String[0]);
        exception.initCause(cause);
        SimulatedSyncErrors.store((ExternalSystemException)exception);
    }

    private static void store(@NotNull ExternalSystemException exception) {
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors", "store"));
        }
        ApplicationManager.getApplication().putUserData(SIMULATED_ERROR_KEY, (Object)exception);
    }

    public static void simulateRegisteredSyncError() {
        Application application = ApplicationManager.getApplication();
        ExternalSystemException error = (ExternalSystemException)application.getUserData(SIMULATED_ERROR_KEY);
        if (error != null) {
            SimulatedSyncErrors.verifyIsTestMode();
            application.putUserData(SIMULATED_ERROR_KEY, null);
            throw error;
        }
    }

    private static void verifyIsTestMode() {
        if (!SimulatedSyncErrors.isTestMode()) {
            throw new IllegalStateException("Not in unit or UI test mode");
        }
    }

    private static boolean isTestMode() {
        return AndroidPlugin.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }
}

