/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.BuildFileComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CompatibilityChecksMetadata {
    @NonNls
    private static final String BUILD_FILE_PREFIX = "buildFile:";
    @NonNls
    private static final String METADATA_FILE_NAME = "android-component-compatibility.xml";
    private final int myDataVersion;
    @NotNull
    private final List<CompatibilityCheck> myCompatibilityChecks = new ArrayList<CompatibilityCheck>();
    @NotNull
    private final Map<String, ComponentVersionReader> myReadersByComponentName = new ConcurrentHashMap<String, ComponentVersionReader>();

    @NotNull
    static CompatibilityChecksMetadata reload() {
        File metadataFilePath = CompatibilityChecksMetadata.getSourceFilePath();
        if (metadataFilePath.isFile()) {
            CompatibilityChecksMetadata compatibilityChecksMetadata;
            try {
                Element root = JDOMUtil.load((File)metadataFilePath);
                compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
            }
            catch (Throwable e) {
                String message = "Failed to load/parse file '" + metadataFilePath.getPath() + "'. Loading metadata from local file.";
                CompatibilityChecksMetadata.getLogger().info(message, e);
                CompatibilityChecksMetadata compatibilityChecksMetadata2 = CompatibilityChecksMetadata.loadLocal();
                if (compatibilityChecksMetadata2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "reload"));
                }
                return compatibilityChecksMetadata2;
            }
            if (compatibilityChecksMetadata == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "reload"));
            }
            return compatibilityChecksMetadata;
        }
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.loadLocal();
        if (compatibilityChecksMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "reload"));
        }
        return compatibilityChecksMetadata;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static CompatibilityChecksMetadata loadLocal() {
        InputStream inputStream = CompatibilityChecksMetadata.class.getResourceAsStream(METADATA_FILE_NAME);
        Throwable throwable = null;
        Element root = JDOMUtil.load((InputStream)inputStream);
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
        CompatibilityChecksMetadata compatibilityChecksMetadata2 = compatibilityChecksMetadata;
        if (compatibilityChecksMetadata2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "loadLocal"));
        }
        return compatibilityChecksMetadata2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            {
                catch (RuntimeException e) {
                    CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
                    throw e;
                }
                catch (Throwable e) {
                    CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void logFailureToReadLocalFile(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "logFailureToReadLocalFile"));
        }
        CompatibilityChecksMetadata.getLogger().info("Failed to load/parse local metadata file.", e);
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(CompatibilityChecksMetadata.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getLogger"));
        }
        return logger;
    }

    @VisibleForTesting
    @NotNull
    static CompatibilityChecksMetadata reloadForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "reloadForTesting"));
        }
        Element root = JDOMUtil.load((Reader)new StringReader(metadata));
        CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
        if (compatibilityChecksMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "reloadForTesting"));
        }
        return compatibilityChecksMetadata;
    }

    @NotNull
    static File getSourceFilePath() {
        File configPath = new File(FileUtil.toSystemDependentName((String)PathManager.getConfigPath()));
        File file = new File(configPath, METADATA_FILE_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getSourceFilePath"));
        }
        return file;
    }

    @NotNull
    static CompatibilityChecksMetadata load(@NotNull Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "load"));
        }
        String dataVersionText = root.getAttributeValue("version");
        int dataVersion = 1;
        try {
            dataVersion = Integer.parseInt(dataVersionText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CompatibilityChecksMetadata metadata = new CompatibilityChecksMetadata(dataVersion);
        for (Element checkElement : root.getChildren("check")) {
            Element componentElement = checkElement.getChild("component");
            Component version = CompatibilityChecksMetadata.createComponent(componentElement, metadata);
            for (Element requirementElement : componentElement.getChildren("requires")) {
                version.addRequirement(CompatibilityChecksMetadata.createComponent(requirementElement, metadata));
            }
            String type = checkElement.getAttributeValue("failureType");
            CompatibilityCheck check = new CompatibilityCheck(version, CompatibilityChecksMetadata.getFailureType(type));
            metadata.myCompatibilityChecks.add(check);
        }
        CompatibilityChecksMetadata compatibilityChecksMetadata = metadata;
        if (compatibilityChecksMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "load"));
        }
        return compatibilityChecksMetadata;
    }

    @NotNull
    private static MessageType getFailureType(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getFailureType"));
        }
        MessageType type = MessageType.findByName(value);
        MessageType messageType = type != null ? type : MessageType.ERROR;
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getFailureType"));
        }
        return messageType;
    }

    @NotNull
    private static Component createComponent(@NotNull Element xmlElement, @NotNull CompatibilityChecksMetadata metadata) {
        if (xmlElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "createComponent"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "createComponent"));
        }
        String name = xmlElement.getAttribute("name").getValue();
        if (name.startsWith(BUILD_FILE_PREFIX)) {
            name = name.substring(BUILD_FILE_PREFIX.length());
            metadata.addIfAbsent(name, new BuildFileComponentVersionReader(name));
        }
        String version = xmlElement.getAttributeValue("version");
        String failureMsg = null;
        Element failureMsgElement = xmlElement.getChild("failureMsg");
        if (failureMsgElement != null) {
            failureMsg = Strings.emptyToNull((String)failureMsgElement.getTextNormalize());
        }
        Component component = new Component(name, version, failureMsg);
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "createComponent"));
        }
        return component;
    }

    CompatibilityChecksMetadata(int dataVersion) {
        this.myDataVersion = dataVersion;
        this.myReadersByComponentName.put("gradle", ComponentVersionReader.GRADLE);
        this.myReadersByComponentName.put("android-gradle-plugin", ComponentVersionReader.ANDROID_GRADLE_PLUGIN);
        this.myReadersByComponentName.put("android-gradle-experimental-plugin", ComponentVersionReader.ANDROID_GRADLE_EXPERIMENTAL_PLUGIN);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myReadersByComponentName.put("android-studio", ComponentVersionReader.ANDROID_STUDIO);
        }
    }

    private void addIfAbsent(@NotNull String name, @NotNull ComponentVersionReader componentVersionReader) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "addIfAbsent"));
        }
        if (componentVersionReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentVersionReader", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "addIfAbsent"));
        }
        this.myReadersByComponentName.putIfAbsent(name, componentVersionReader);
    }

    int getDataVersion() {
        return this.myDataVersion;
    }

    ComponentVersionReader findComponentVersionReader(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "findComponentVersionReader"));
        }
        return this.myReadersByComponentName.get(name);
    }

    @NotNull
    List<CompatibilityCheck> getCompatibilityChecks() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myCompatibilityChecks);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getCompatibilityChecks"));
        }
        return immutableList;
    }

    @NotNull
    Map<String, ComponentVersionReader> getReadersByComponentName() {
        Map<String, ComponentVersionReader> map = this.myReadersByComponentName;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/CompatibilityChecksMetadata", "getReadersByComponentName"));
        }
        return map;
    }
}

