/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ToggleOfflineModeHyperlink;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedDependencyNotFoundErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine;
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && (firstLine = CachedDependencyNotFoundErrorHandler.getFirstLineMessage(text)).startsWith("No cached version of ") && firstLine.contains("available for offline mode.")) {
            CachedDependencyNotFoundErrorHandler.updateUsageTracker();
            return firstLine;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
        if (disableOfflineMode != null) {
            hyperlinks.add(disableOfflineMode);
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/CachedDependencyNotFoundErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

