/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ToggleOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MissingDependencyErrorHandler
extends SyncErrorHandler {
    private static final Pattern MISSING_MATCHING_DEPENDENCY_PATTERN = Pattern.compile("Could not find any version that matches (.*)\\.");
    private static final Pattern MISSING_DEPENDENCY_PATTERN = Pattern.compile("Could not find (.*)\\.");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleError"));
        }
        Throwable rootCause = this.getRootCause((Throwable)error);
        String text = rootCause.getMessage();
        List message = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text);
        String firstLine = (String)message.get(0);
        Matcher matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, firstLine, dependency, Collections.emptyList());
            return true;
        }
        String lastLine = (String)message.get(message.size() - 1);
        matcher = MISSING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches() && message.size() > 1 && ((String)message.get(1)).startsWith("Required by:")) {
            String dependency = matcher.group(1);
            ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
            if (StringUtil.isNotEmpty((String)dependency)) {
                Pair<String, Integer> errorLocation;
                if (lastLine != null && (errorLocation = this.getErrorLocation(lastLine)) != null) {
                    String filePath = (String)errorLocation.getFirst();
                    int line = (Integer)errorLocation.getSecond();
                    hyperlinks.add(new OpenFileHyperlink(filePath, line - 1));
                }
                MissingDependencyErrorHandler.handleMissingDependency(notification, project, error.getMessage(), dependency, hyperlinks);
                return true;
            }
        }
        for (String line : message) {
            if (line == null || !(matcher = MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(line)).matches()) continue;
            String dependency = matcher.group(1);
            MissingDependencyErrorHandler.handleMissingDependency(notification, project, line, dependency, Collections.emptyList());
            return true;
        }
        return false;
    }

    private static void handleMissingDependency(@NotNull NotificationData notification, @NotNull Project project, @NotNull String msg, @NotNull String dependency, @NotNull List<NotificationHyperlink> additionalHyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        if (additionalHyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalHyperlinks", "com/android/tools/idea/gradle/project/sync/errors/MissingDependencyErrorHandler", "handleMissingDependency"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>(additionalHyperlinks);
        ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
        if (disableOfflineMode != null) {
            hyperlinks.add(0, disableOfflineMode);
        }
        hyperlinks.add(new SearchInBuildFilesHyperlink(dependency));
        SyncMessages.getInstance(project).updateNotification(notification, msg, hyperlinks);
    }
}

