/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NdkIntegrationDeprecatedErrorHandler
extends BaseSyncErrorHandler {
    private static final String NDK_INTEGRATION_DEPRECATED = "NDK integration is deprecated in the current plugin.";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && NdkIntegrationDeprecatedErrorHandler.getFirstLineMessage(text).contains(NDK_INTEGRATION_DEPRECATED)) {
            NdkIntegrationDeprecatedErrorHandler.updateUsageTracker();
            return NDK_INTEGRATION_DEPRECATED;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("https://developer.android.com/studio/build/experimental-plugin.html", "Consider trying the new experimental plugin"));
        hyperlinks.add(new SetUseDeprecatedNdkHyperlink());
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }

    public static class SetUseDeprecatedNdkHyperlink
    extends NotificationHyperlink {
        public SetUseDeprecatedNdkHyperlink() {
            super("useDeprecatedNdk", "Set \"android.useDeprecatedNdk=true\" in gradle.properties to continue using the current NDK integration");
        }

        @Override
        protected void execute(@NotNull Project project) {
            GradleProperties gradleProperties;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/NdkIntegrationDeprecatedErrorHandler$SetUseDeprecatedNdkHyperlink", "execute"));
            }
            try {
                gradleProperties = new GradleProperties(project);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to read gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            gradleProperties.getProperties().setProperty("android.useDeprecatedNdk", "true");
            try {
                gradleProperties.save();
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Failed to update gradle.properties: " + e.getMessage()), (String)"Quick Fix");
                return;
            }
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }
}

